/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.listener;

import com.handy.playertask.api.PlayerTaskApi;
import com.handy.playertask.constants.TaskTypeEnum;
import com.handy.playertask.entity.TaskNpcPlayer;
import com.handy.playertask.entity.TaskNpcPlayerDemand;
import com.handy.playertask.entity.TaskPlayer;
import com.handy.playertask.entity.TaskPlayerDemand;
import com.handy.playertask.entity.TaskReel;
import com.handy.playertask.entity.TaskReelPlayerDemand;
import com.handy.playertask.event.PlayerTaskScheduleEvent;
import com.handy.playertask.lib.annotation.HandyListener;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.StrUtil;
import com.handy.playertask.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertask.lib.util.ItemStackUtil;
import com.handy.playertask.reward.RewardStrategy;
import com.handy.playertask.service.TaskNpcPlayerDemandService;
import com.handy.playertask.service.TaskNpcPlayerService;
import com.handy.playertask.service.TaskPlayerDemandService;
import com.handy.playertask.service.TaskPlayerService;
import com.handy.playertask.service.TaskReelPlayerDemandService;
import com.handy.playertask.service.TaskReelService;
import com.handy.playertask.util.ConfigUtil;
import com.handy.playertask.util.TaskUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class PlayerTaskScheduleEventListener
implements Listener {
    @EventHandler
    public void onPlayerTaskSchedule(PlayerTaskScheduleEvent event) {
        Player player = event.getPlayer();
        Integer amount = event.getAmount();
        String content = event.getContent();
        String demandType = event.getDemandType();
        HandySchedulerUtil.runTaskAsynchronously(() -> {
            this.everyday(player, amount, content, demandType);
            this.npc(player, amount, content, demandType);
            this.reel(player, amount, content, demandType);
        });
    }

    private void everyday(Player player, Integer amount, String content, String demandType) {
        List<TaskPlayerDemand> taskPlayerDemandList = TaskPlayerDemandService.getInstance().findByPlayerAndContent(player.getUniqueId(), content, demandType);
        if (CollUtil.isEmpty(taskPlayerDemandList)) {
            return;
        }
        for (TaskPlayerDemand taskPlayerDemand : taskPlayerDemandList) {
            TaskPlayerDemandService.getInstance().updateCompletionAmount(taskPlayerDemand.getId(), amount);
            this.sendTaskDemandScheduleMsg(player, demandType, taskPlayerDemand.getAmount(), taskPlayerDemand.getCompletionAmount() + amount, content, taskPlayerDemand.getTaskPlayerId(), TaskTypeEnum.EVERYDAY);
        }
    }

    private void npc(Player player, Integer amount, String content, String demandType) {
        List<TaskNpcPlayerDemand> taskNpcPlayerDemandList = TaskNpcPlayerDemandService.getInstance().findByPlayerAndContent(player.getUniqueId(), content, demandType);
        if (CollUtil.isEmpty(taskNpcPlayerDemandList)) {
            return;
        }
        for (TaskNpcPlayerDemand taskNpcPlayerDemand : taskNpcPlayerDemandList) {
            TaskNpcPlayerDemandService.getInstance().updateCompletionAmount(taskNpcPlayerDemand.getId(), amount);
            this.sendTaskDemandScheduleMsg(player, demandType, taskNpcPlayerDemand.getAmount(), taskNpcPlayerDemand.getCompletionAmount() + amount, content, taskNpcPlayerDemand.getTaskNpcPlayerId(), TaskTypeEnum.NPC);
        }
    }

    private void reel(Player player, Integer amount, String content, String demandType) {
        List<TaskReelPlayerDemand> taskReelPlayerDemandList = TaskReelPlayerDemandService.getInstance().findByPlayerAndContent(player.getUniqueId(), content, demandType);
        if (CollUtil.isEmpty(taskReelPlayerDemandList)) {
            return;
        }
        Material material = ItemStackUtil.getMaterial(ConfigUtil.REEL_CONFIG.getString("reel.material", Material.PAPER.name()));
        for (TaskReelPlayerDemand taskReelPlayerDemand : taskReelPlayerDemandList) {
            ItemStack[] contents;
            Integer reelId = taskReelPlayerDemand.getReelId();
            PlayerInventory inventory = player.getInventory();
            for (ItemStack itemStack : contents = inventory.getContents()) {
                Optional<TaskReel> taskReelOptional;
                ItemMeta itemMeta;
                int enchantLevel;
                if (itemStack == null || !itemStack.getType().equals((Object)material) || itemStack.getAmount() > 1 || (enchantLevel = (itemMeta = ItemStackUtil.getItemMeta(itemStack)).getEnchantLevel(Enchantment.LURE)) == 0 || !(taskReelOptional = TaskReelService.getInstance().findByIdAndPlayer(reelId, player.getUniqueId())).isPresent() || enchantLevel != taskReelOptional.get().getPlayerReelId()) continue;
                TaskReelPlayerDemandService.getInstance().updateCompletionAmount(taskReelPlayerDemand.getId(), amount);
                this.doneTaskReel(player, amount, content, demandType, taskReelPlayerDemand, itemStack);
            }
        }
    }

    private void doneTaskReel(Player player, Integer amount, String content, String demandType, TaskReelPlayerDemand taskReelPlayerDemand, ItemStack itemStack) {
        Optional<TaskReel> taskReelDoneOptional = TaskReelService.getInstance().findByIdAndPlayer(taskReelPlayerDemand.getReelId(), player.getUniqueId());
        if (!taskReelDoneOptional.isPresent()) {
            return;
        }
        TaskReel taskReel = taskReelDoneOptional.get();
        ItemStack taskItemStack = TaskUtil.createTaskItemStack(taskReel, player);
        itemStack.setItemMeta(taskItemStack.getItemMeta());
        this.sendTaskDemandScheduleMsg(player, demandType, taskReelPlayerDemand.getAmount(), taskReelPlayerDemand.getCompletionAmount() + amount, content, taskReelPlayerDemand.getReelId(), TaskTypeEnum.REEL);
    }

    private void sendTaskDemandScheduleMsg(Player player, String demandType, Integer amount, Integer completionAmount, String content, Integer taskPlayerId, TaskTypeEnum type) {
        PlayerTaskApi.getInstance().sendCurrentProgressMsg(player, demandType, amount, completionAmount, content);
        if (completionAmount < amount) {
            return;
        }
        switch (type) {
            case EVERYDAY: {
                Optional<TaskPlayer> taskPlayerOptional = TaskPlayerService.getInstance().findById(taskPlayerId);
                if (!taskPlayerOptional.isPresent()) {
                    return;
                }
                TaskPlayer taskPlayer = taskPlayerOptional.get();
                PlayerTaskApi.getInstance().sendTaskManagerMsg(player, taskPlayer.getTaskName());
                if (TaskPlayerDemandService.getInstance().findCountByTaskPlayerId(taskPlayerId)) {
                    return;
                }
                PlayerTaskApi.getInstance().sendTaskFinishMsg(player, taskPlayer.getTaskName());
                this.autoReward(player, taskPlayer);
                break;
            }
            case NPC: {
                Optional<TaskNpcPlayer> taskNpcPlayerOptional = TaskNpcPlayerService.getInstance().findById(taskPlayerId);
                if (!taskNpcPlayerOptional.isPresent()) {
                    return;
                }
                TaskNpcPlayer taskNpcPlayer = taskNpcPlayerOptional.get();
                PlayerTaskApi.getInstance().sendTaskManagerMsg(player, taskNpcPlayer.getTaskName());
                if (TaskNpcPlayerDemandService.getInstance().findCountByTaskNpcPlayerId(taskPlayerId)) {
                    return;
                }
                PlayerTaskApi.getInstance().sendTaskFinishMsg(player, taskNpcPlayer.getTaskName());
                break;
            }
            case REEL: {
                Optional<TaskReel> taskReelOptional = TaskReelService.getInstance().findById(taskPlayerId);
                if (!taskReelOptional.isPresent()) {
                    return;
                }
                TaskReel taskReel = taskReelOptional.get();
                PlayerTaskApi.getInstance().sendTaskManagerMsg(player, taskReel.getTaskName());
                if (TaskReelPlayerDemandService.getInstance().findCountByReelId(taskPlayerId)) {
                    return;
                }
                PlayerTaskApi.getInstance().sendTaskFinishMsg(player, taskReel.getTaskName());
                break;
            }
        }
    }

    private synchronized void autoReward(Player player, TaskPlayer taskPlayer) {
        if (!ConfigUtil.CONFIG.getBoolean("autoReward", false)) {
            return;
        }
        Optional<TaskPlayer> taskPlayerOptional = TaskPlayerService.getInstance().findById(taskPlayer.getId());
        if (!taskPlayerOptional.isPresent()) {
            return;
        }
        if (taskPlayerOptional.get().getStatus().booleanValue()) {
            return;
        }
        TaskPlayerService.getInstance().updateById(taskPlayer.getId(), true);
        RewardStrategy.getInstance().playerReward(player, StrUtil.strToIntList(taskPlayer.getTaskRewards()));
    }
}

