/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertask.reward;

import com.handy.playertask.constants.BaseTaskConstants;
import com.handy.playertask.constants.RewardTypeEnum;
import com.handy.playertask.entity.TaskRewards;
import com.handy.playertask.lib.core.CollUtil;
import com.handy.playertask.lib.core.SignUtil;
import com.handy.playertask.lib.util.MessageUtil;
import com.handy.playertask.reward.IRewardService;
import com.handy.playertask.reward.impl.CoinRewardServiceImpl;
import com.handy.playertask.reward.impl.CommandServiceImpl;
import com.handy.playertask.reward.impl.ItemStackRewardServiceImpl;
import com.handy.playertask.reward.impl.PlayerPointsRewardServiceImpl;
import com.handy.playertask.reward.impl.VaultRewardServiceImpl;
import com.handy.playertask.service.TaskRewardsService;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public class RewardStrategy {
    private RewardStrategy() {
    }

    public static RewardStrategy getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void batchReward(List<Player> playerList, List<Integer> taskRewardIdList) {
        if (CollUtil.isEmpty(playerList) || CollUtil.isEmpty(taskRewardIdList)) {
            return;
        }
        List<TaskRewards> taskRewardsList = TaskRewardsService.getInstance().findByIds(taskRewardIdList);
        for (Player player : playerList) {
            this.reward(player, taskRewardsList);
        }
    }

    public void playerReward(Player player, List<Integer> taskRewardIdList) {
        this.batchReward(Collections.singletonList(player), taskRewardIdList);
    }

    public void reward(Player player, List<TaskRewards> taskRewardsList) {
        if (CollUtil.isEmpty(taskRewardsList)) {
            return;
        }
        if (BaseTaskConstants.STOP && !SignUtil.isGenuine()) {
            MessageUtil.sendMessage(player, BaseTaskConstants.TIP);
            return;
        }
        block7: for (TaskRewards taskRewards : taskRewardsList) {
            IRewardService rewardService;
            RewardTypeEnum rewardTypeEnum = RewardTypeEnum.getEnumThrow(taskRewards.getType());
            if (taskRewards.getAmount() == null || taskRewards.getAmount() == 0) continue;
            switch (rewardTypeEnum) {
                case VAULT: {
                    rewardService = new VaultRewardServiceImpl();
                    break;
                }
                case PLAYER_POINTS: {
                    rewardService = new PlayerPointsRewardServiceImpl();
                    break;
                }
                case COIN: {
                    rewardService = new CoinRewardServiceImpl();
                    break;
                }
                case ITEM_STACK: {
                    rewardService = new ItemStackRewardServiceImpl();
                    break;
                }
                case COMMAND: {
                    rewardService = new CommandServiceImpl();
                    break;
                }
                default: {
                    continue block7;
                }
            }
            rewardService.reward(player, taskRewards);
        }
    }

    private static class SingletonHolder {
        private static final RewardStrategy INSTANCE = new RewardStrategy();

        private SingletonHolder() {
        }
    }
}

