/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.constants.RewardTypeEnum;
import com.handy.playertitle.entity.TitleReward;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.core.NumberUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.ItemStackUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleRewardService;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AddRewardCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "addReward";
    }

    @Override
    public String permission() {
        return "playerTitle.addReward";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Boolean rst;
        AssertUtil.notTrue(args.length < 4, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Integer number = AssertUtil.isNumericToInt(args[1], sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        TitleReward titleReward = new TitleReward();
        titleReward.setNumber(number);
        RewardTypeEnum typeEnum = RewardTypeEnum.getEnumThrow(args[2]);
        titleReward.setRewardType(args[2]);
        Integer amount = NumberUtil.isNumericToInt(args[3]);
        AssertUtil.notTrue(amount == null || amount < 0, sender, BaseUtil.getMsgNotColor("amountFailureMsg"));
        titleReward.setAmount(amount);
        if (RewardTypeEnum.ITEM_STACK.equals((Object)typeEnum)) {
            Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
            ItemStack itemInMainHand = ItemStackUtil.getItemInMainHand(player.getInventory());
            AssertUtil.notTrue(Material.AIR.equals((Object)itemInMainHand.getType()), sender, BaseUtil.getMsgNotColor("noAir"));
            titleReward.setItemStack(ItemStackUtil.itemStackSerialize(itemInMainHand));
        }
        MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor((rst = TitleRewardService.getInstance().add(titleReward)) != false ? "succeedMsg" : "failureMsg"));
    }
}

