/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.entity.TitleBuff;
import com.handy.playertitle.entity.TitleCoin;
import com.handy.playertitle.entity.TitleList;
import com.handy.playertitle.entity.TitleParticle;
import com.handy.playertitle.entity.TitlePlayer;
import com.handy.playertitle.entity.TitleReward;
import com.handy.playertitle.entity.TitleRewardLog;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.constants.BaseConstants;
import com.handy.playertitle.lib.db.Db;
import com.handy.playertitle.lib.db.SqlManagerUtil;
import com.handy.playertitle.lib.db.enums.DbTypeEnum;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.HandyConfigUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.service.TitleBuffService;
import com.handy.playertitle.service.TitleCoinService;
import com.handy.playertitle.service.TitleListService;
import com.handy.playertitle.service.TitleParticleService;
import com.handy.playertitle.service.TitlePlayerService;
import com.handy.playertitle.service.TitleRewardLogService;
import com.handy.playertitle.service.TitleRewardService;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class ConvertCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "convert";
    }

    @Override
    public String permission() {
        return "playerTitle.convert";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        String storageMethod = args[1];
        if (!DbTypeEnum.MySQL.getType().equalsIgnoreCase(storageMethod) && !DbTypeEnum.SQLite.getType().equalsIgnoreCase(storageMethod)) {
            MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
            return;
        }
        if (storageMethod.equalsIgnoreCase(SqlManagerUtil.getInstance().getStorageMethod())) {
            MessageUtil.sendMessage(sender, "&4\u7981\u6b62\u8f6c\u6362\uff01\u539f\u56e0\uff0c\u60a8\u5f53\u524d\u4f7f\u7528\u7684\u5b58\u50a8\u65b9\u5f0f\u5df2\u7ecf\u4e3a\uff1a" + storageMethod);
            return;
        }
        List<TitleBuff> all = TitleBuffService.getInstance().findAll();
        List<TitleCoin> all1 = TitleCoinService.getInstance().findAll();
        List<TitleList> all3 = TitleListService.getInstance().findAll();
        List<TitleParticle> all4 = TitleParticleService.getInstance().findAll();
        List<TitlePlayer> all5 = TitlePlayerService.getInstance().findAll();
        List<TitleRewardLog> all6 = TitleRewardLogService.getInstance().findAll();
        List<TitleReward> all7 = TitleRewardService.getInstance().findAll();
        HandyConfigUtil.setPath(BaseConstants.STORAGE_CONFIG, "storage-method", storageMethod, Collections.singletonList("\u5b58\u50a8\u65b9\u6cd5(MySQL,SQLite)\u8bf7\u590d\u5236\u62ec\u53f7\u5185\u7684\u7c7b\u578b,\u4e0d\u8981\u81ea\u5df1\u5199"), "storage.yml");
        SqlManagerUtil.enableSql();
        Db.use(TitleBuff.class).execution().create();
        Db.use(TitleCoin.class).execution().create();
        Db.use(TitleList.class).execution().create();
        Db.use(TitleParticle.class).execution().create();
        Db.use(TitlePlayer.class).execution().create();
        Db.use(TitleRewardLog.class).execution().create();
        Db.use(TitleReward.class).execution().create();
        Db.use(TitleBuff.class).execution().insertBatch(all);
        Db.use(TitleCoin.class).execution().insertBatch(all1);
        Db.use(TitleList.class).execution().insertBatch(all3);
        Db.use(TitleParticle.class).execution().insertBatch(all4);
        Db.use(TitlePlayer.class).execution().insertBatch(all5);
        Db.use(TitleRewardLog.class).execution().insertBatch(all6);
        Db.use(TitleReward.class).execution().insertBatch(all7);
        MessageUtil.sendMessage(sender, "&4\u8f6c\u6362\u6570\u636e\u5b8c\u6210\uff0c\u8bf7\u52a1\u5fc5\u91cd\u542f\u670d\u52a1\u5668\uff0c\u4e0d\u7136\u6709\u53ef\u80fd\u4f1a\u51fa\u73b0\u672a\u77e5bug");
    }
}

