/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.command.admin;

import com.handy.playertitle.constants.CommandChildTypeEnum;
import com.handy.playertitle.inventory.ViewOpenGui;
import com.handy.playertitle.inventory.ViewRewardGui;
import com.handy.playertitle.inventory.ViewShopGui;
import com.handy.playertitle.lib.command.IHandyCommandEvent;
import com.handy.playertitle.lib.expand.adapter.HandySchedulerUtil;
import com.handy.playertitle.lib.util.AssertUtil;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ViewCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "view";
    }

    @Override
    public String permission() {
        return "playerTitle.view";
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Inventory inventory;
        AssertUtil.notTrue(args.length < 2, sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
        Player player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        switch (CommandChildTypeEnum.getEnum(args[1], "view")) {
            case VIEW_REWARD: {
                inventory = ViewRewardGui.getInstance().createGui(player);
                break;
            }
            case VIEW_SHOP: {
                inventory = ViewShopGui.getInstance().createGui(player);
                break;
            }
            case VIEW_OPEN: {
                if (args.length < 3) {
                    MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                    return;
                }
                inventory = ViewOpenGui.getInstance().createGui(args[2]);
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("paramFailureMsg"));
                return;
            }
        }
        HandySchedulerUtil.runTask(() -> player.openInventory(inventory));
    }
}

