/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.constants.TitleConstants;
import com.handy.playertitle.constants.TitleUseTypeEnum;
import com.handy.playertitle.inventory.OpenGui;
import com.handy.playertitle.inventory.SelectGui;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.lib.util.BaseUtil;
import com.handy.playertitle.lib.util.MessageUtil;
import com.handy.playertitle.util.ConfigUtil;
import com.handy.playertitle.util.TitleUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public class SelectClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.SELECT.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, "back")) {
            Inventory inventory = OpenGui.getInstance().createGui(player, handyInventory.getPageNum());
            handyInventory.syncOpen(inventory);
            return;
        }
        boolean rst = false;
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, TitleUseTypeEnum.SHOW.getUseType())) {
            rst = this.useTitle(player, handyInventory.getId(), TitleUseTypeEnum.SHOW);
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, TitleUseTypeEnum.BUFF.getUseType())) {
            rst = this.useTitle(player, handyInventory.getId(), TitleUseTypeEnum.BUFF);
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.SELECT_CONFIG, TitleUseTypeEnum.PARTICLE.getUseType())) {
            rst = this.useTitle(player, handyInventory.getId(), TitleUseTypeEnum.PARTICLE);
        }
        if (rst) {
            SelectGui.getInstance().setInventoryDate(handyInventory);
        }
    }

    private boolean useTitle(Player player, Integer titlePlayerId, TitleUseTypeEnum useType) {
        long time;
        Long dateTime;
        int togglesCoolDown = ConfigUtil.CONFIG.getInt("togglesCoolDown");
        if (togglesCoolDown != 0 && (dateTime = TitleConstants.TOGGLES_COOL_DOWN_MAP.get(player.getUniqueId())) != null && (time = (long)togglesCoolDown - (System.currentTimeMillis() - dateTime) / 1000L) > 0L) {
            String langMsg = BaseUtil.getLangMsg("togglesCoolDownMsg");
            MessageUtil.sendMessage(player, StrUtil.replace(langMsg, "time", Long.toString(time)));
            return false;
        }
        TitleConstants.TOGGLES_COOL_DOWN_MAP.put(player.getUniqueId(), System.currentTimeMillis());
        TitleUtil.playerTitleUse(player, titlePlayerId, useType, false);
        return true;
    }
}

