/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.listener.gui;

import com.handy.playertitle.constants.GuiTypeEnum;
import com.handy.playertitle.inventory.ViewRewardGui;
import com.handy.playertitle.lib.core.StrUtil;
import com.handy.playertitle.lib.inventory.HandyInventory;
import com.handy.playertitle.lib.inventory.HandyInventoryUtil;
import com.handy.playertitle.lib.inventory.IHandyClickEvent;
import com.handy.playertitle.service.TitleRewardService;
import com.handy.playertitle.util.ConfigUtil;
import java.util.List;
import java.util.Map;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ViewRewardClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.VIEW_REWARD.getType();
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Integer pageNum = handyInventory.getPageNum();
        Integer pageCount = handyInventory.getPageCount();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "previousPage")) {
            if (pageNum > 1) {
                handyInventory.setPageNum(handyInventory.getPageNum() - 1);
                ViewRewardGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.REWARD_CONFIG, "nextPage")) {
            if (pageNum + 1 <= pageCount) {
                handyInventory.setPageNum(handyInventory.getPageNum() + 1);
                ViewRewardGui.getInstance().setInventoryDate(handyInventory);
            }
            return;
        }
        List<Integer> indexList = StrUtil.strToIntList(ConfigUtil.REWARD_CONFIG.getString("reward.index"));
        if (indexList.contains(rawSlot) && map.get(event.getRawSlot()) != null) {
            Integer titleRewardId = map.get(event.getRawSlot());
            TitleRewardService.getInstance().removeById(titleRewardId);
            ViewRewardGui.getInstance().setInventoryDate(handyInventory);
        }
    }
}

