/*
 * Decompiled with CFR 0.152.
 */
package com.handy.playertitle.constants;

import com.handy.playertitle.PlayerTitle;
import com.handy.playertitle.lib.BaseUtil;
import dev.esophose.playerparticles.styles.DefaultStyles;
import dev.esophose.playerparticles.styles.ParticleStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum DefaultStylesEnum {
    ARROWS("ARROWS", DefaultStyles.ARROWS),
    BATMAN("BATMAN", DefaultStyles.BATMAN),
    BEAM("BEAM", DefaultStyles.BEAM),
    BLOCK_BREAK("BLOCK_BREAK", DefaultStyles.BLOCKBREAK),
    BLOCK_PLACE("BLOCK_PLACE", DefaultStyles.BLOCKPLACE),
    CELEBRATION("CELEBRATION", DefaultStyles.CELEBRATION),
    CHAINS("CHAINS", DefaultStyles.CHAINS),
    COMPANION("COMPANION", DefaultStyles.COMPANION),
    CUBE("CUBE", DefaultStyles.CUBE),
    DEATH("DEATH", DefaultStyles.DEATH),
    FEET("FEET", DefaultStyles.FEET),
    FISHING("FISHING", DefaultStyles.FISHING),
    HALO("HALO", DefaultStyles.HALO),
    HURT("HURT", DefaultStyles.HURT),
    ICO_SPHERE("ICO_SPHERE", DefaultStyles.ICOSPHERE),
    INVOCATION("INVOCATION", DefaultStyles.INVOCATION),
    MOVE("MOVE", DefaultStyles.MOVE),
    NORMAL("NORMAL", DefaultStyles.NORMAL),
    ORBIT("ORBIT", DefaultStyles.ORBIT),
    OUTLINE("OUTLINE", DefaultStyles.OUTLINE),
    OVERHEAD("OVERHEAD", DefaultStyles.OVERHEAD),
    POINT("POINT", DefaultStyles.POINT),
    POPPER("POPPER", DefaultStyles.POPPER),
    PULSE("PULSE", DefaultStyles.PULSE),
    QUAD_HELIX("QUAD_HELIX", DefaultStyles.QUADHELIX),
    RINGS("RINGS", DefaultStyles.RINGS),
    SPHERE("SPHERE", DefaultStyles.SPHERE),
    SPIN("SPIN", DefaultStyles.SPIN),
    SPIRAL("SPIRAL", DefaultStyles.SPIRAL),
    SWORDS("SWORDS", DefaultStyles.SWORDS),
    TELEPORT("TELEPORT", DefaultStyles.TELEPORT),
    THICK("THICK", DefaultStyles.THICK),
    TRAIL("TRAIL", DefaultStyles.TRAIL),
    TWINS("TWINS", DefaultStyles.TWINS),
    VORTEX("VORTEX", DefaultStyles.VORTEX),
    WHIRL("WHIRL", DefaultStyles.WHIRL),
    WHIRLWIND("WHIRLWIND", DefaultStyles.WHIRLWIND),
    WINGS("WINGS", DefaultStyles.WINGS);

    private final String name;
    private final ParticleStyle particleStyle;

    public static List<String> getParticleStyleEnum() {
        if (PlayerTitle.PP_API == null) {
            return new ArrayList<String>();
        }
        return Arrays.stream(DefaultStylesEnum.values()).map(DefaultStylesEnum::getName).collect(Collectors.toList());
    }

    public static String getCustomName(String name) {
        return BaseUtil.getLangMsg("playerParticles." + name.toLowerCase());
    }

    public static ParticleStyle getDefaultStyle(String name) {
        for (DefaultStylesEnum defaultStylesEnum : DefaultStylesEnum.values()) {
            if (!defaultStylesEnum.getName().equalsIgnoreCase(name)) continue;
            return defaultStylesEnum.getParticleStyle();
        }
        return DefaultStyles.NORMAL;
    }

    public String getName() {
        return this.name;
    }

    public ParticleStyle getParticleStyle() {
        return this.particleStyle;
    }

    private DefaultStylesEnum(String name, ParticleStyle particleStyle) {
        this.name = name;
        this.particleStyle = particleStyle;
    }
}

