/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.command;

import cn.handyplus.warp.constants.TabListEnum;
import cn.handyplus.warp.lib.annotation.HandyCommand;
import cn.handyplus.warp.lib.command.HandyCommandFactory;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.util.ConfigUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.util.StringUtil;

@HandyCommand(name="playerWarp")
public class PlayerWarpCommand
implements TabExecutor {
    private static final String PERMISSION = "playerWarp.reload";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            return this.sendHelp(sender);
        }
        boolean rst = HandyCommandFactory.getInstance().onCommand(sender, cmd, label, args, BaseUtil.getLangMsg("noPermission"));
        if (!rst) {
            return this.sendHelp(sender);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<Object> commands = !sender.hasPermission(PERMISSION) ? new ArrayList() : TabListEnum.returnList(args, args.length);
        if (commands == null) {
            return null;
        }
        StringUtil.copyPartialMatches((String)args[args.length - 1].toLowerCase(), commands, completions);
        Collections.sort(completions);
        return completions;
    }

    private Boolean sendHelp(CommandSender sender) {
        if (!sender.hasPermission(PERMISSION)) {
            return true;
        }
        List helps = ConfigUtil.LANG_CONFIG.getStringList("helps");
        for (String help : helps) {
            sender.sendMessage(BaseUtil.replaceChatColor(help));
        }
        return true;
    }
}

