/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.constants;

import cn.handyplus.warp.lib.util.BaseUtil;
import java.util.ArrayList;
import java.util.List;

public enum WarpTypeEnum {
    ALL("all", "warpType.all", 1),
    ARCHITECT("architect", "warpType.architect", 2),
    SHOP("shop", "warpType.shop", 3),
    RED_STONE("red_stone", "warpType.red_stone", 4),
    BRUSH_MONSTER("brush_monster", "warpType.brush_monster", 5),
    OTHER("other", "warpType.other", 6);

    private final String type;
    private final String desc;
    private final int id;

    public static WarpTypeEnum getEnum(String type) {
        for (WarpTypeEnum warpTypeEnum : WarpTypeEnum.values()) {
            if (!warpTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return warpTypeEnum;
        }
        return ALL;
    }

    public static String getDesc(String type) {
        return WarpTypeEnum.getDesc(WarpTypeEnum.getEnum(type));
    }

    public static String getDesc(WarpTypeEnum warpTypeEnum) {
        return BaseUtil.getLangMsg(warpTypeEnum.getDesc());
    }

    public static List<String> getNotAllList() {
        ArrayList<String> list = new ArrayList<String>();
        for (WarpTypeEnum warpTypeEnum : WarpTypeEnum.values()) {
            if (warpTypeEnum.getType().equals(ALL.getType())) continue;
            list.add(warpTypeEnum.getType());
        }
        return list;
    }

    public static WarpTypeEnum getNextEnum(String name) {
        WarpTypeEnum anEnum = WarpTypeEnum.getEnum(name);
        if (anEnum == null) {
            return ALL;
        }
        int num = anEnum.getId() + 1;
        if (num > 6) {
            num = 1;
        }
        for (WarpTypeEnum warpTypeEnum : WarpTypeEnum.values()) {
            if (warpTypeEnum.getId() != num) continue;
            return warpTypeEnum;
        }
        return ALL;
    }

    public static WarpTypeEnum getNotAllNextEnum(String name) {
        WarpTypeEnum anEnum = WarpTypeEnum.getEnum(name);
        if (anEnum == null) {
            return ARCHITECT;
        }
        int num = anEnum.getId() + 1;
        if (num > 6) {
            num = 2;
        }
        for (WarpTypeEnum warpTypeEnum : WarpTypeEnum.values()) {
            if (warpTypeEnum.getId() != num) continue;
            return warpTypeEnum;
        }
        return ARCHITECT;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getId() {
        return this.id;
    }

    private WarpTypeEnum(String type, String desc, int id) {
        this.type = type;
        this.desc = desc;
        this.id = id;
    }
}

