/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.DateUtil;
import cn.handyplus.warp.lib.core.MapUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.db.enter.Page;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.ItemStackUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.service.WarpLikePlayerService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MeGui {
    private static final MeGui INSTANCE = new MeGui();

    private MeGui() {
    }

    public static MeGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player, OpenParam openParam) {
        String title = ConfigUtil.ME_CONFIG.getString("title");
        int size = ConfigUtil.ME_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.ME.getType(), title, size);
        handyInventory.setPlayer(player);
        handyInventory.setObj(openParam);
        handyInventory.setSearchType(WarpTypeEnum.ALL.getType());
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.ME.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        String guiIndexStr = ConfigUtil.ME_CONFIG.getString("warp.index", "20,21,22,23,24,29,30,31,32,33");
        List<Integer> guiIndexList = StrUtil.strToIntList(guiIndexStr);
        handyInventory.setPageSize(guiIndexList.size());
        Page<WarpPlayer> page = WarpPlayerService.getInstance().page(player.getName(), handyInventory.getPageNum(), handyInventory.getPageSize(), handyInventory.getSearchType(), null, null);
        handyInventory.setPageCount(page.getTotal());
        List<WarpPlayer> records = page.getRecords();
        if (CollUtil.isEmpty(records)) {
            return;
        }
        String name = ConfigUtil.ME_CONFIG.getString("warp.name", "");
        List loreList = ConfigUtil.ME_CONFIG.getStringList("warp.lore");
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        for (WarpPlayer warpPlayer : records) {
            List<String> newLoreList = new ArrayList<String>();
            String warpName = name.replace("${warp_name}", warpPlayer.getName());
            Map<String, String> replaceMap = this.replaceMap(warpPlayer);
            for (String lore : loreList) {
                for (String str : replaceMap.keySet()) {
                    lore = lore.replace("${" + str + "}", replaceMap.get(str));
                }
                newLoreList.add(lore);
            }
            newLoreList = ItemStackUtil.loreBatchReplaceMap(newLoreList, WarpUtil.getDescriptionMap(warpPlayer.getDescription()), "");
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(warpPlayer.getLogoName());
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, warpName)));
            itemMeta.setLore(BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, newLoreList)));
            ItemStackUtil.hideAttributes(itemMeta);
            ItemStackUtil.hideEnchant(itemMeta);
            itemStack.setItemMeta(itemMeta);
            itemStackMap.put(warpPlayer.getId(), itemStack);
        }
        int i = 0;
        for (Integer id : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(id));
            map.put(index, id);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.ME_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.ME_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.ME_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.ME_CONFIG, inventory, "search", this.replaceSearchMap(handyInventory));
        HandyInventoryUtil.setCustomButton(ConfigUtil.ME_CONFIG, handyInventory, "custom");
    }

    private Map<String, String> replaceSearchMap(HandyInventory handyInventory) {
        String searchType = handyInventory.getSearchType();
        WarpTypeEnum guildSortEnum = WarpTypeEnum.getEnum(searchType);
        WarpTypeEnum nextEnum = WarpTypeEnum.getNextEnum(searchType);
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        map.put("type", WarpTypeEnum.getDesc(guildSortEnum));
        map.put("nextType", WarpTypeEnum.getDesc(nextEnum));
        return map;
    }

    private Map<String, String> replaceMap(WarpPlayer warpPlayer) {
        int i;
        HashMap<String, String> replaceMap = MapUtil.newHashMapWithExpectedSize(12);
        replaceMap.put("id", warpPlayer.getId().toString());
        replaceMap.put("name", warpPlayer.getName());
        replaceMap.put("warp_type", WarpTypeEnum.getDesc(warpPlayer.getType()));
        replaceMap.put("time", DateUtil.format(warpPlayer.getCreateTime(), "yyyy-MM-dd"));
        replaceMap.put("player", warpPlayer.getCreator());
        replaceMap.put("price", warpPlayer.getPrice().toString());
        replaceMap.put("tp_number", warpPlayer.getTpNumber().toString());
        replaceMap.put("thermal_value", warpPlayer.getThermalValue().toString());
        replaceMap.put("top_index", warpPlayer.getTopIndex() != null ? warpPlayer.getTopIndex().toString() : "");
        replaceMap.put("top_time", warpPlayer.getTopTime() != null ? DateUtil.format(warpPlayer.getTopTime(), "yyyy-MM-dd HH:mm:ss") : "");
        replaceMap.put("expiration_time", warpPlayer.getExpirationTime() != null ? DateUtil.format(warpPlayer.getExpirationTime(), "yyyy-MM-dd HH:mm:ss") : "");
        replaceMap.put("display", ConfigUtil.ADMIN_CONFIG.getString(warpPlayer.getDisplay() != false ? "yesDisplay" : "noDisplay"));
        StringBuilder likeStr = new StringBuilder();
        Integer likeNumber = WarpLikePlayerService.getInstance().findLikeByWarpId(warpPlayer.getId());
        String like = ConfigUtil.OPEN_CONFIG.getString("like");
        String dislike = ConfigUtil.OPEN_CONFIG.getString("dislike");
        for (i = 0; i < likeNumber; ++i) {
            likeStr.append(like);
        }
        for (i = 0; i < 5 - likeNumber; ++i) {
            likeStr.append(dislike);
        }
        replaceMap.put("like", likeStr.toString());
        return replaceMap;
    }
}

