/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.inventory;

import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.db.enter.Page;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import cn.handyplus.warp.lib.util.ItemStackUtil;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ViewGui {
    private static final ViewGui INSTANCE = new ViewGui();

    private ViewGui() {
    }

    public static ViewGui getInstance() {
        return INSTANCE;
    }

    public Inventory createGui(Player player) {
        String title = ConfigUtil.VIEW_CONFIG.getString("title");
        int size = ConfigUtil.VIEW_CONFIG.getInt("size", 54);
        HandyInventory handyInventory = new HandyInventory(GuiTypeEnum.VIEW.getType(), title, size);
        handyInventory.setPlayer(player);
        this.setInventoryDate(handyInventory);
        return handyInventory.getInventory();
    }

    public void setInventoryDate(HandyInventory handyInventory) {
        handyInventory.setGuiType(GuiTypeEnum.VIEW.getType());
        HandyInventoryUtil.refreshInventory(handyInventory.getInventory());
        this.setDate(handyInventory);
        this.setFunctionMenu(handyInventory);
    }

    private void setDate(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Player player = handyInventory.getPlayer();
        Map<Integer, Integer> map = handyInventory.getIntMap();
        String guiIndexStr = ConfigUtil.VIEW_CONFIG.getString("warp.index", "20,21,22,23,24,29,30,31,32,33");
        List<Integer> guiIndexList = StrUtil.strToIntList(guiIndexStr);
        handyInventory.setPageSize(guiIndexList.size());
        Page<WarpPlayer> page = WarpPlayerService.getInstance().page(handyInventory.getPageNum(), guiIndexList.size());
        handyInventory.setPageCount(page.getTotal());
        if (page.getTotal() < 1) {
            return;
        }
        String name = ConfigUtil.VIEW_CONFIG.getString("warp.name", "");
        List loreList = ConfigUtil.VIEW_CONFIG.getStringList("warp.lore");
        LinkedHashMap<Integer, ItemStack> itemStackMap = new LinkedHashMap<Integer, ItemStack>();
        for (WarpPlayer warpPlayer : page.getRecords()) {
            List<String> newLoreList = new ArrayList<String>();
            String warpName = name.replace("${warp_name}", warpPlayer.getName());
            Map<String, String> replaceMap = OpenGui.getInstance().replaceMap(warpPlayer);
            for (String lore : loreList) {
                for (String str : replaceMap.keySet()) {
                    lore = lore.replace("${" + str + "}", replaceMap.get(str));
                }
                newLoreList.add(lore);
            }
            newLoreList = ItemStackUtil.loreBatchReplaceMap(newLoreList, WarpUtil.getDescriptionMap(warpPlayer.getDescription()), "");
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(warpPlayer.getLogoName());
            ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
            itemMeta.setDisplayName(BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, warpName)));
            itemMeta.setLore(BaseUtil.replaceChatColor(PlaceholderApiUtil.set(player, newLoreList)));
            ItemStackUtil.hideAttributes(itemMeta);
            ItemStackUtil.hideEnchant(itemMeta);
            itemStack.setItemMeta(itemMeta);
            itemStackMap.put(warpPlayer.getId(), itemStack);
        }
        int i = 0;
        for (Integer id : itemStackMap.keySet()) {
            Integer index = guiIndexList.get(i++);
            inventory.setItem(index.intValue(), (ItemStack)itemStackMap.get(id));
            map.put(index, id);
        }
    }

    private void setFunctionMenu(HandyInventory handyInventory) {
        Inventory inventory = handyInventory.getInventory();
        Map<String, String> replacePageMap = HandyInventoryUtil.replacePageMap(handyInventory);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "nextPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "previousPage", replacePageMap);
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "back");
        HandyInventoryUtil.setButton(ConfigUtil.VIEW_CONFIG, inventory, "pane");
    }
}

