/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.lib.annotation.HandyCommand;
import cn.handyplus.warp.lib.annotation.HandyListener;
import cn.handyplus.warp.lib.annotation.HandySubCommand;
import cn.handyplus.warp.lib.annotation.TableName;
import cn.handyplus.warp.lib.command.HandyCommandFactory;
import cn.handyplus.warp.lib.command.HandySubCommandParam;
import cn.handyplus.warp.lib.command.IHandyCommandEvent;
import cn.handyplus.warp.lib.constants.BaseConstants;
import cn.handyplus.warp.lib.constants.VersionCheckEnum;
import cn.handyplus.warp.lib.core.ClassUtil;
import cn.handyplus.warp.lib.core.CollUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.db.Db;
import cn.handyplus.warp.lib.db.SqlManagerUtil;
import cn.handyplus.warp.lib.expand.bstats.bukkit.Metrics;
import cn.handyplus.warp.lib.expand.bstats.charts.CustomChart;
import cn.handyplus.warp.lib.expand.bstats.charts.SimplePie;
import cn.handyplus.warp.lib.inventory.HandyClickFactory;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.lib.metrics.PluginNameCallable;
import cn.handyplus.warp.lib.metrics.VersionCallable;
import cn.handyplus.warp.lib.util.BcUtil;
import cn.handyplus.warp.lib.util.HandyHttpUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.event.Listener;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.permissions.DefaultPermissions;

public class InitApi {
    private static final String VERSION = "3.7.4";
    private static final InitApi INSTANCE = new InitApi();
    public static JavaPlugin PLUGIN;
    private static ClassUtil CLASS_UTIL;

    private InitApi() {
    }

    public static InitApi getInstance(JavaPlugin plugin) {
        PLUGIN = plugin;
        BaseConstants.VERSION_CHECK_ENUM = VersionCheckEnum.getEnum();
        BaseConstants.VERSION_ID = BaseConstants.VERSION_CHECK_ENUM.getVersionId();
        CLASS_UTIL = new ClassUtil();
        InitApi.handyMetrics();
        return INSTANCE;
    }

    private static void handyMetrics() {
        try {
            Metrics metrics = new Metrics(PLUGIN, 12612);
            metrics.addCustomChart(new SimplePie("version", new VersionCallable(VERSION)));
            metrics.addCustomChart(new SimplePie("pluginName", new PluginNameCallable(PLUGIN.getName())));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public InitApi initCommand(String packageName) {
        Map<Class<?>, List<Method>> methodsMap;
        List<Class<IHandyCommandEvent>> handyCommandEventList;
        List<Class<?>> commandList = CLASS_UTIL.getClassByAnnotation(packageName, HandyCommand.class);
        if (CollUtil.isNotEmpty(commandList)) {
            for (Class<?> aClass : commandList) {
                HandyCommand handyCommand = aClass.getAnnotation(HandyCommand.class);
                PluginCommand pluginCommand = Bukkit.getPluginCommand((String)handyCommand.name());
                if (pluginCommand == null) continue;
                if (aClass.newInstance() instanceof CommandExecutor) {
                    pluginCommand.setExecutor((CommandExecutor)aClass.newInstance());
                }
                if (aClass.newInstance() instanceof TabExecutor) {
                    pluginCommand.setTabCompleter((TabCompleter)((TabExecutor)aClass.newInstance()));
                }
                if (handyCommand.aliases().length > 0) {
                    pluginCommand.setAliases(Arrays.asList(handyCommand.aliases()));
                }
                pluginCommand.setDescription(handyCommand.description());
                pluginCommand.setUsage(handyCommand.usage());
                pluginCommand.setPermissionMessage(handyCommand.permissionMessage());
                if (!StrUtil.isNotEmpty(handyCommand.permission())) continue;
                pluginCommand.setPermission(handyCommand.permission());
                DefaultPermissions.registerPermission((String)handyCommand.permission(), null, (PermissionDefault)handyCommand.PERMISSION_DEFAULT());
            }
        }
        if (CollUtil.isNotEmpty(handyCommandEventList = CLASS_UTIL.getClassByIsAssignableFrom(packageName, IHandyCommandEvent.class))) {
            ArrayList<IHandyCommandEvent> handyCommandEvents = new ArrayList<IHandyCommandEvent>();
            for (Class clazz : handyCommandEventList) {
                handyCommandEvents.add((IHandyCommandEvent)clazz.newInstance());
            }
            HandyCommandFactory.getInstance().init(handyCommandEvents);
        }
        if (!(methodsMap = CLASS_UTIL.getMethodByAnnotation(packageName, HandySubCommand.class)).isEmpty()) {
            ArrayList<HandySubCommandParam> subCommandParamList = new ArrayList<HandySubCommandParam>();
            for (Class<?> clazz : methodsMap.keySet()) {
                for (Method method : methodsMap.get(clazz)) {
                    HandySubCommand handySubCommand = method.getAnnotation(HandySubCommand.class);
                    HandySubCommandParam param = new HandySubCommandParam();
                    param.setCommand(handySubCommand.mainCommand().toLowerCase().trim());
                    param.setSubCommand(handySubCommand.subCommand().toLowerCase().trim());
                    param.setPermission(handySubCommand.permission().trim());
                    param.setAClass(clazz);
                    param.setMethod(method);
                    subCommandParamList.add(param);
                }
            }
            Map<String, Map<String, HandySubCommandParam>> map = subCommandParamList.stream().collect(Collectors.groupingBy(HandySubCommandParam::getCommand, Collectors.groupingBy(HandySubCommandParam::getSubCommand, Collectors.collectingAndThen(Collectors.toList(), value -> (HandySubCommandParam)value.get(0)))));
            HandyCommandFactory.getInstance().initSubCommand(map);
        }
        return this;
    }

    public InitApi initListener(String packageName) {
        return this.initListener(packageName, null);
    }

    public InitApi initListener(String packageName, List<String> ignoreList) {
        List<Class<?>> listenerTypesAnnotatedWith = CLASS_UTIL.getClassByAnnotation(packageName, HandyListener.class);
        if (CollUtil.isEmpty(listenerTypesAnnotatedWith)) {
            return this;
        }
        for (Class<?> aClass : listenerTypesAnnotatedWith) {
            HandyListener handyListener;
            if (CollUtil.isNotEmpty(ignoreList) && ignoreList.contains(aClass.getName()) || (handyListener = aClass.getAnnotation(HandyListener.class)) == null || BaseConstants.VERSION_ID < handyListener.version().getVersionId()) continue;
            PLUGIN.getServer().getPluginManager().registerEvents((Listener)aClass.newInstance(), (Plugin)PLUGIN);
        }
        return this;
    }

    public InitApi initClickEvent(String packageName) {
        List<Class<IHandyClickEvent>> handyClickEventList = CLASS_UTIL.getClassByIsAssignableFrom(packageName, IHandyClickEvent.class);
        if (CollUtil.isEmpty(handyClickEventList)) {
            return this;
        }
        ArrayList<IHandyClickEvent> handyClickEvents = new ArrayList<IHandyClickEvent>();
        for (Class<IHandyClickEvent> aClass : handyClickEventList) {
            handyClickEvents.add(aClass.newInstance());
        }
        HandyClickFactory.getInstance().init(handyClickEvents);
        return this;
    }

    public InitApi checkVersion(boolean isVersion, String url) {
        if (isVersion) {
            HandyHttpUtil.checkVersion(null, url);
        }
        return this;
    }

    public InitApi addMetrics(int pluginId) {
        return this.addMetrics(pluginId, null);
    }

    public InitApi addMetrics(int pluginId, List<CustomChart> customCharts) {
        try {
            Metrics metrics = new Metrics(PLUGIN, pluginId);
            if (CollUtil.isNotEmpty(customCharts)) {
                for (CustomChart customChart : customCharts) {
                    metrics.addCustomChart(customChart);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public InitApi enableSql(String packageName) {
        List<Class<?>> tableList = CLASS_UTIL.getClassByAnnotation(packageName, TableName.class);
        if (CollUtil.isEmpty(tableList)) {
            return this;
        }
        SqlManagerUtil.enableSql();
        for (Class<?> aClass : tableList) {
            Db.use(aClass).execution().create();
        }
        return this;
    }

    public InitApi enableBc() {
        BcUtil.registerOut();
        return this;
    }
}

