/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.util;

import cn.handyplus.warp.lib.InitApi;
import cn.handyplus.warp.lib.constants.BaseConstants;
import cn.handyplus.warp.lib.core.JsonUtil;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.param.BcMessageParam;
import cn.handyplus.warp.lib.util.MessageUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BcUtil {
    public static String CONNECT = "Connect";
    public static String FORWARD = "Forward";
    public static String GET_SERVER = "GetServer";
    public static String PLAYER_COUNT = "PlayerCount";
    public static String ALL = "ALL";

    public static void registerOut() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)InitApi.PLUGIN, BaseConstants.BUNGEE_CORD_CHANNEL);
    }

    public static void unregisterOut() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)InitApi.PLUGIN, BaseConstants.BUNGEE_CORD_CHANNEL);
    }

    public static void tpConnect(Player player, String serverName) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(CONNECT);
        out.writeUTF(serverName);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BaseConstants.BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static void sendForward(Player player, String content) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(FORWARD);
        out.writeUTF("ALL");
        out.writeUTF(BaseConstants.BUNGEE_CORD_CHANNEL);
        ByteArrayDataOutput dataOut = ByteStreams.newDataOutput();
        dataOut.writeUTF(content);
        out.writeShort(dataOut.toByteArray().length);
        out.write(dataOut.toByteArray());
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BaseConstants.BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static Optional<String> getContentByForward(byte[] message) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subChannel = in.readUTF();
        if (!BaseConstants.BUNGEE_CORD_CHANNEL.equals(subChannel)) {
            return Optional.empty();
        }
        byte[] bytes = new byte[in.readShort()];
        in.readFully(bytes);
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])bytes);
        return Optional.of(dataInput.readUTF());
    }

    public static void sendParamForward(Player player, BcMessageParam content) {
        BcUtil.sendForward(player, JsonUtil.toJson(content));
    }

    public static Optional<BcMessageParam> getParamByForward(byte[] message) {
        Optional<String> jsonOpt = BcUtil.getContentByForward(message);
        if (!jsonOpt.isPresent()) {
            return Optional.empty();
        }
        MessageUtil.sendConsoleDebugMessage("\u6d88\u606f\u5185\u5bb9\u4e3a:" + jsonOpt.get());
        BcMessageParam param = JsonUtil.toBean(jsonOpt.get(), BcMessageParam.class);
        if (param == null || StrUtil.isEmpty(param.getPluginName()) || !InitApi.PLUGIN.getName().equals(param.getPluginName())) {
            return Optional.empty();
        }
        return Optional.of(param);
    }

    public static void sendGetServer() {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(GET_SERVER);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BaseConstants.BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static Optional<String> getServerName(byte[] message) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String type = in.readUTF();
        if (!GET_SERVER.equals(type)) {
            return Optional.empty();
        }
        return Optional.of(in.readUTF());
    }

    public static void sendPlayerCount() {
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(PLAYER_COUNT);
        out.writeUTF(ALL);
        player.sendPluginMessage((Plugin)InitApi.PLUGIN, BaseConstants.BUNGEE_CORD_CHANNEL, out.toByteArray());
    }

    public static Map<String, Integer> getPlayerCount(byte[] message) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String type = in.readUTF();
        if (!PLAYER_COUNT.equals(type)) {
            return new HashMap<String, Integer>();
        }
        String server = in.readUTF();
        int count = in.readInt();
        return ImmutableMap.of((Object)server, (Object)count);
    }
}

