/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.util;

import cn.handyplus.warp.lib.constants.BaseConstants;
import cn.handyplus.warp.lib.constants.VersionCheckEnum;
import cn.handyplus.warp.lib.core.StrUtil;
import cn.handyplus.warp.lib.util.BaseUtil;
import java.util.Arrays;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;

public class RgbTextUtil {
    private BaseComponent[] baseComponents;

    private RgbTextUtil() {
    }

    public static RgbTextUtil getInstance() {
        return new RgbTextUtil();
    }

    public RgbTextUtil init(String msg) {
        return this.init(msg, true);
    }

    public RgbTextUtil init(String msg, boolean isColor) {
        this.baseComponents = TextComponent.fromLegacyText((String)(isColor ? BaseUtil.replaceChatColor(msg) : msg));
        return this;
    }

    public RgbTextUtil addClick(ClickEvent.Action action, String msg) {
        if (StrUtil.isEmpty(msg)) {
            return this;
        }
        for (BaseComponent baseComponent : this.baseComponents) {
            baseComponent.setClickEvent(new ClickEvent(action, msg));
        }
        return this;
    }

    public RgbTextUtil addClickUrl(String url) {
        return this.addClick(ClickEvent.Action.OPEN_URL, url);
    }

    public RgbTextUtil addClickCommand(String command) {
        return this.addClick(ClickEvent.Action.RUN_COMMAND, command);
    }

    public RgbTextUtil addClickSuggestCommand(String suggestCommand) {
        return this.addClick(ClickEvent.Action.SUGGEST_COMMAND, suggestCommand);
    }

    public RgbTextUtil addClickCopyToClipboard(String text) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_15.getVersionId()) {
            return this;
        }
        return this.addClick(ClickEvent.Action.COPY_TO_CLIPBOARD, BaseUtil.replaceChatColor(text));
    }

    public RgbTextUtil addHoverText(String text) {
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_16.getVersionId()) {
            return this;
        }
        if (StrUtil.isEmpty(text)) {
            return this;
        }
        for (BaseComponent baseComponent : this.baseComponents) {
            baseComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(TextComponent.fromLegacyText((String)text))}));
        }
        return this;
    }

    public RgbTextUtil addExtra(BaseComponent[] extra) {
        this.baseComponents = (BaseComponent[])Stream.concat(Arrays.stream(this.baseComponents), Arrays.stream(extra)).toArray(BaseComponent[]::new);
        return this;
    }

    public BaseComponent[] build() {
        return this.baseComponents;
    }
}

