/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.listener.gui;

import cn.handyplus.warp.PlayerWarp;
import cn.handyplus.warp.constants.GuiTypeEnum;
import cn.handyplus.warp.constants.WarpConstants;
import cn.handyplus.warp.hook.PlayerPointsUtil;
import cn.handyplus.warp.hook.VaultUtil;
import cn.handyplus.warp.inventory.OpenGui;
import cn.handyplus.warp.lib.inventory.HandyInventory;
import cn.handyplus.warp.lib.inventory.HandyInventoryUtil;
import cn.handyplus.warp.lib.inventory.IHandyClickEvent;
import cn.handyplus.warp.lib.util.MessageUtil;
import cn.handyplus.warp.param.OpenParam;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WarpCreateClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.CREATE.getType();
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        final int rawSlot = event.getRawSlot();
        final Player player = handyInventory.getPlayer();
        final OpenParam openParam = (OpenParam)handyInventory.getObj();
        new BukkitRunnable(){

            public void run() {
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_CONFIG, "back")) {
                    Inventory inventory = OpenGui.getInstance().createGui(player, openParam);
                    Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> player.openInventory(inventory));
                    return;
                }
                boolean rst = false;
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_CONFIG, "point")) {
                    if (WarpUtil.checkWarpNumber(player)) {
                        return;
                    }
                    int pointPrice = ConfigUtil.CREATE_CONFIG.getInt("point.price");
                    rst = PlayerPointsUtil.buy(player, pointPrice);
                }
                if (HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.CREATE_CONFIG, "vault")) {
                    if (WarpUtil.checkWarpNumber(player)) {
                        return;
                    }
                    int vaultPrice = ConfigUtil.CREATE_CONFIG.getInt("vault.price");
                    rst = VaultUtil.buy(player, vaultPrice);
                }
                if (!rst) {
                    MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("notMoneyFailureMsg"));
                    return;
                }
                WarpConstants.CHAT_CACHE_MAP.put(player.getUniqueId(), "add");
                MessageUtil.sendMessage(player, ConfigUtil.CREATE_CONFIG.getString("nameMsg"));
                Bukkit.getScheduler().runTask((Plugin)PlayerWarp.getInstance(), () -> ((Player)player).closeInventory());
            }
        }.runTaskAsynchronously((Plugin)PlayerWarp.getInstance());
    }
}

