/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.bukkit.queue.LimitedRegionWrapperQueue;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.UncheckedWorldLocation;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import java.util.Random;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;

final class BlockStatePopulator
extends BlockPopulator {
    private final IndependentPlotGenerator plotGenerator;

    public BlockStatePopulator(@NonNull IndependentPlotGenerator plotGenerator) {
        this.plotGenerator = plotGenerator;
    }

    public void populate(@NonNull WorldInfo worldInfo, @NonNull Random random, int chunkX, int chunkZ, @NonNull LimitedRegion limitedRegion) {
        HybridPlotWorld hpw;
        PlotArea area = UncheckedWorldLocation.at(worldInfo.getName(), chunkX << 4, 0, chunkZ << 4).getPlotArea();
        if (area == null || area instanceof HybridPlotWorld && !(hpw = (HybridPlotWorld)area).populationNeeded() || area instanceof SinglePlotArea) {
            return;
        }
        LimitedRegionWrapperQueue wrapped = new LimitedRegionWrapperQueue(limitedRegion);
        UncheckedWorldLocation min = UncheckedWorldLocation.at(worldInfo.getName(), chunkX << 4, worldInfo.getMinHeight(), chunkZ << 4);
        UncheckedWorldLocation max = UncheckedWorldLocation.at(worldInfo.getName(), (chunkX << 4) + 15, worldInfo.getMaxHeight(), (chunkZ << 4) + 15);
        ZeroedDelegateScopedQueueCoordinator offsetChunkQueue = new ZeroedDelegateScopedQueueCoordinator(wrapped, min, max);
        this.plotGenerator.populateChunk(offsetChunkQueue, area);
    }
}

