/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.generator;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.generator.HybridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.location.UncheckedWorldLocation;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.world.SinglePlotArea;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.World;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.generator.BlockPopulator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LegacyBlockStatePopulator
extends BlockPopulator {
    private final IndependentPlotGenerator plotGenerator;

    public LegacyBlockStatePopulator(@NonNull IndependentPlotGenerator plotGenerator) {
        this.plotGenerator = plotGenerator;
    }

    public void populate(@NonNull org.bukkit.World world, @NonNull Random random, @NonNull Chunk source) {
        HybridPlotWorld hpw;
        int chunkMinX = source.getX() << 4;
        int chunkMinZ = source.getZ() << 4;
        PlotArea area = Location.at(world.getName(), chunkMinX, 0, chunkMinZ).getPlotArea();
        if (area == null || area instanceof HybridPlotWorld && !(hpw = (HybridPlotWorld)area).populationNeeded() || area instanceof SinglePlotArea) {
            return;
        }
        QueueCoordinator queue = PlotSquared.platform().globalBlockQueue().getNewQueue((World)new BukkitWorld(world));
        queue.setForceSync(true);
        queue.setSideEffectSet(SideEffectSet.none());
        queue.setBiomesEnabled(false);
        queue.setChunkObject(source);
        UncheckedWorldLocation min = UncheckedWorldLocation.at(world.getName(), chunkMinX, world.getMinHeight(), chunkMinZ);
        UncheckedWorldLocation max = UncheckedWorldLocation.at(world.getName(), chunkMinX + 15, world.getMaxHeight(), chunkMinZ + 15);
        ZeroedDelegateScopedQueueCoordinator offsetChunkQueue = new ZeroedDelegateScopedQueueCoordinator(queue, min, max);
        this.plotGenerator.populateChunk(offsetChunkQueue, area);
        queue.enqueue();
    }
}

