/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.managers;

import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.util.PlatformWorldManager;
import com.plotsquared.google.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Singleton
public class BukkitWorldManager
implements PlatformWorldManager<World> {
    @Override
    public void initialize() {
    }

    @Override
    public @Nullable World handleWorldCreation(@NonNull String worldName, @Nullable String generator) {
        this.setGenerator(worldName, generator);
        WorldCreator wc = new WorldCreator(worldName);
        wc.environment(World.Environment.NORMAL);
        if (generator != null) {
            wc.generator(generator);
            wc.type(WorldType.FLAT);
        }
        return Bukkit.createWorld((WorldCreator)wc);
    }

    protected void setGenerator(@Nullable String worldName, @Nullable String generator) {
        if (generator == null) {
            return;
        }
        File file = new File("bukkit.yml").getAbsoluteFile();
        YamlConfiguration yml = YamlConfiguration.loadConfiguration(file);
        yml.set(String.format("worlds.%s.generator", worldName), generator);
        try {
            yml.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "bukkit";
    }

    @Override
    public Collection<String> getWorlds() {
        List worlds = Bukkit.getWorlds();
        ArrayList<String> worldNames = new ArrayList<String>();
        for (World world : worlds) {
            worldNames.add(world.getName());
        }
        return worldNames;
    }
}

