/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.player;

import com.plotsquared.core.permissions.NullPermissionProfile;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.permissions.PermissionProfile;
import com.plotsquared.core.player.OfflinePlotPlayer;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BukkitOfflinePlayer
implements OfflinePlotPlayer {
    public final OfflinePlayer player;
    private final PermissionProfile permissionProfile;

    public BukkitOfflinePlayer(@NonNull OfflinePlayer player, @NonNull PermissionHandler permissionHandler) {
        this.player = player;
        this.permissionProfile = permissionHandler.getPermissionProfile(this).orElse(NullPermissionProfile.INSTANCE);
    }

    @Override
    public @NonNull UUID getUUID() {
        return this.player.getUniqueId();
    }

    @Override
    public @NonNegative long getLastPlayed() {
        return this.player.getLastSeen();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean hasPermission(@Nullable String world, @NonNull String permission) {
        return this.permissionProfile.hasPermission(world, permission);
    }

    @Override
    public boolean hasKeyedPermission(@Nullable String world, @NonNull String stub, @NonNull String key) {
        return this.permissionProfile.hasPermission(world, stub + "." + key) || this.permissionProfile.hasPermission(world, stub + ".*");
    }

    @Override
    public boolean hasPermission(@NonNull String permission, boolean notify) {
        return this.hasPermission(permission);
    }
}

