/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.bukkit.generator.BukkitPlotGenerator;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.inject.annotations.WorldFile;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;

@Singleton
public class BukkitSetupUtils
extends SetupUtils {
    private final PlotAreaManager plotAreaManager;
    private final YamlConfiguration worldConfiguration;
    private final File worldFile;

    @Inject
    public BukkitSetupUtils(@NonNull PlotAreaManager plotAreaManager, @WorldConfig @NonNull YamlConfiguration worldConfiguration, @WorldFile @NonNull File worldFile) {
        this.plotAreaManager = plotAreaManager;
        this.worldConfiguration = worldConfiguration;
        this.worldFile = worldFile;
    }

    @Override
    public void updateGenerators(boolean force) {
        if (this.loaded && !SetupUtils.generators.isEmpty() && !force) {
            return;
        }
        String testWorld = "CheckingPlotSquaredGenerator";
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            try {
                ChunkGenerator generator;
                if (!plugin.isEnabled() || (generator = plugin.getDefaultWorldGenerator(testWorld, "")) == null) continue;
                PlotSquared.get().removePlotAreas(testWorld);
                String name = plugin.getDescription().getName();
                GeneratorWrapper wrapped = generator instanceof GeneratorWrapper ? (GeneratorWrapper)generator : new BukkitPlotGenerator(testWorld, generator, this.plotAreaManager);
                SetupUtils.generators.put(name, wrapped);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.loaded = true;
    }

    @Override
    public void unload(String worldName, boolean save) {
        TaskManager.runTask(() -> {
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                return;
            }
            Location location = ((World)Bukkit.getWorlds().get(0)).getSpawnLocation();
            for (Player player : world.getPlayers()) {
                player.teleport(location);
            }
            if (save) {
                for (Chunk chunk : world.getLoadedChunks()) {
                    chunk.unload(true);
                }
            } else {
                for (Chunk chunk : world.getLoadedChunks()) {
                    chunk.unload(false);
                }
            }
            Bukkit.unloadWorld((World)world, (boolean)false);
        });
    }

    @Override
    public String setupWorld(PlotAreaBuilder builder) {
        this.updateGenerators(false);
        ConfigurationNode[] steps = builder.settingsNodesWrapper() == null ? new ConfigurationNode[]{} : builder.settingsNodesWrapper().settingsNodes();
        String world = builder.worldName();
        PlotAreaType type = builder.plotAreaType();
        String worldPath = "worlds." + builder.worldName();
        switch (type) {
            case PARTIAL: {
                GeneratorWrapper<?> gen;
                ConfigurationSection worldSection;
                if (builder.areaName() != null) {
                    String areaName;
                    String areaPath;
                    if (!this.worldConfiguration.contains(worldPath)) {
                        this.worldConfiguration.createSection(worldPath);
                    }
                    if (!(worldSection = this.worldConfiguration.getConfigurationSection(worldPath)).contains(areaPath = "areas." + (areaName = builder.areaName() + "-" + builder.minimumId() + "-" + builder.maximumId()))) {
                        worldSection.createSection(areaPath);
                    }
                    ConfigurationSection areaSection = worldSection.getConfigurationSection(areaPath);
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    for (ConfigurationNode step : steps) {
                        options.put(step.getConstant(), step.getValue());
                    }
                    options.put("generator.type", builder.plotAreaType().toString());
                    options.put("generator.terrain", builder.terrainType().toString());
                    options.put("generator.plugin", builder.plotManager());
                    if (builder.generatorName() != null && !builder.generatorName().equals(builder.plotManager())) {
                        options.put("generator.init", builder.generatorName());
                    }
                    for (Map.Entry entry : options.entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (worldSection.contains(key)) {
                            Object current = worldSection.get(key);
                            if (Objects.equals(value, current)) continue;
                            areaSection.set(key, value);
                            continue;
                        }
                        worldSection.set(key, value);
                    }
                }
                if ((gen = SetupUtils.generators.get(builder.generatorName())) == null || !gen.isFull()) break;
                builder.generatorName(null);
                break;
            }
            case AUGMENTED: {
                GeneratorWrapper<?> gen;
                ConfigurationSection worldSection;
                if (!builder.plotManager().endsWith(":single")) {
                    if (!this.worldConfiguration.contains(worldPath)) {
                        this.worldConfiguration.createSection(worldPath);
                    }
                    if (steps.length != 0) {
                        worldSection = this.worldConfiguration.getConfigurationSection(worldPath);
                        for (ConfigurationNode step : steps) {
                            worldSection.set(step.getConstant(), step.getValue());
                        }
                    }
                    this.worldConfiguration.set("worlds." + world + ".generator.type", builder.plotAreaType().toString());
                    this.worldConfiguration.set("worlds." + world + ".generator.terrain", builder.terrainType().toString());
                    this.worldConfiguration.set("worlds." + world + ".generator.plugin", builder.plotManager());
                    if (builder.generatorName() != null && !builder.generatorName().equals(builder.plotManager())) {
                        this.worldConfiguration.set("worlds." + world + ".generator.init", builder.generatorName());
                    }
                }
                if ((gen = SetupUtils.generators.get(builder.generatorName())) == null || !gen.isFull()) break;
                builder.generatorName(null);
                break;
            }
            case NORMAL: {
                if (steps.length == 0) break;
                if (!this.worldConfiguration.contains(worldPath)) {
                    this.worldConfiguration.createSection(worldPath);
                }
                ConfigurationSection worldSection = this.worldConfiguration.getConfigurationSection(worldPath);
                for (ConfigurationNode step : steps) {
                    worldSection.set(step.getConstant(), step.getValue());
                }
                break;
            }
        }
        try {
            this.worldConfiguration.save(this.worldFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Objects.requireNonNull(PlotSquared.platform()).worldManager().handleWorldCreation(builder.worldName(), builder.generatorName());
        if (Bukkit.getWorld((String)world) != null) {
            return world;
        }
        return builder.worldName();
    }

    @Override
    public String getGenerator(PlotArea plotArea) {
        World world;
        if (SetupUtils.generators.isEmpty()) {
            this.updateGenerators(false);
        }
        if ((world = Bukkit.getWorld((String)plotArea.getWorldName())) == null) {
            return null;
        }
        ChunkGenerator generator = world.getGenerator();
        if (!(generator instanceof BukkitPlotGenerator)) {
            return null;
        }
        for (Map.Entry<String, GeneratorWrapper<?>> entry : SetupUtils.generators.entrySet()) {
            GeneratorWrapper<?> current = entry.getValue();
            if (!current.equals(generator)) continue;
            return entry.getKey();
        }
        return null;
    }
}

