/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.google.common.collect.Maps;
import com.plotsquared.core.location.World;
import java.util.Map;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BukkitWorld
implements World<org.bukkit.World> {
    private static final Map<String, BukkitWorld> worldMap;
    private static final boolean HAS_MIN_Y;
    private final org.bukkit.World world;

    private BukkitWorld(org.bukkit.World world) {
        this.world = world;
    }

    public static @NonNull BukkitWorld of(@NonNull String worldName) {
        org.bukkit.World bukkitWorld = Bukkit.getWorld((String)worldName);
        if (bukkitWorld == null) {
            throw new IllegalArgumentException(String.format("There is no world with the name '%s'", worldName));
        }
        return BukkitWorld.of(bukkitWorld);
    }

    public static @NonNull BukkitWorld of(org.bukkit.World world) {
        BukkitWorld bukkitWorld = worldMap.get(world.getName());
        if (bukkitWorld != null && bukkitWorld.getPlatformWorld().equals(world)) {
            return bukkitWorld;
        }
        bukkitWorld = new BukkitWorld(world);
        worldMap.put(world.getName(), bukkitWorld);
        return bukkitWorld;
    }

    public static int getMinWorldHeight(org.bukkit.World world) {
        return HAS_MIN_Y ? world.getMinHeight() : 0;
    }

    public static int getMaxWorldHeight(org.bukkit.World world) {
        return HAS_MIN_Y ? world.getMaxHeight() : 256;
    }

    @Override
    public org.bukkit.World getPlatformWorld() {
        return this.world;
    }

    @Override
    public @NonNull String getName() {
        return this.world.getName();
    }

    @Override
    public int getMinHeight() {
        return BukkitWorld.getMinWorldHeight(this.world);
    }

    @Override
    public int getMaxHeight() {
        return BukkitWorld.getMaxWorldHeight(this.world) - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BukkitWorld that = (BukkitWorld)o;
        return this.world.equals(that.world);
    }

    public int hashCode() {
        return this.world.hashCode();
    }

    public String toString() {
        return "BukkitWorld(world=" + this.world + ")";
    }

    static {
        boolean temp;
        worldMap = Maps.newHashMap();
        try {
            org.bukkit.World.class.getMethod("getMinHeight", new Class[0]);
            temp = true;
        }
        catch (NoSuchMethodException e) {
            temp = false;
        }
        HAS_MIN_Y = temp;
    }
}

