/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.informative.NotPublic;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

@NotPublic
public class TranslationUpdateManager {
    public static void upgradeTranslationFile() throws IOException {
        String searchText = "suggest_command";
        String replacementText = "run_command";
        try (Stream<Path> paths = Files.walk(Paths.get(PlotSquared.platform().getDirectory().toPath().resolve("lang").toUri()), new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().matches("messages_[a-z]{2}\\.json")).forEach(p -> TranslationUpdateManager.replaceInFile(p, searchText, replacementText));
        }
    }

    private static void replaceInFile(Path path, String searchText, String replacementText) {
        try {
            String content = Files.readString(path);
            if (content.contains(searchText)) {
                content = content.replaceAll(searchText, replacementText);
                Files.writeString(path, (CharSequence)content, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

