/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.bukkit.uuid;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.database.SQLite;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class SQLiteUUIDService
implements UUIDService,
Consumer<List<UUIDMapping>> {
    private final SQLite sqlite;

    public SQLiteUUIDService(String fileName) {
        this.sqlite = new SQLite(FileUtils.getFile(PlotSquared.platform().getDirectory(), fileName));
        try {
            this.sqlite.openConnection();
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        try (PreparedStatement stmt = this.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS `usercache` (uuid VARCHAR(32) NOT NULL, username VARCHAR(32) NOT NULL, PRIMARY KEY (uuid))");){
            stmt.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection() {
        SQLite sQLite = this.sqlite;
        synchronized (sQLite) {
            return this.sqlite.getConnection();
        }
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<UUID> uuids) {
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(uuids.size());
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT `username` FROM `usercache` WHERE `uuid` = ?");){
            for (UUID uuid : uuids) {
                statement.setString(1, uuid.toString());
                ResultSet resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) continue;
                    mappings.add(new UUIDMapping(uuid, resultSet.getString("username")));
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappings;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<String> usernames) {
        ArrayList<UUIDMapping> mappings = new ArrayList<UUIDMapping>(usernames.size());
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT `uuid` FROM `usercache` WHERE `username` = ?");){
            for (String username : usernames) {
                statement.setString(1, username);
                ResultSet resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) continue;
                    mappings.add(new UUIDMapping(UUID.fromString(resultSet.getString("uuid")), username));
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappings;
    }

    @Override
    public void accept(List<UUIDMapping> uuidWrappers) {
        try (PreparedStatement statement = this.getConnection().prepareStatement("INSERT OR REPLACE INTO `usercache` (`uuid`, `username`) VALUES(?, ?)");){
            for (UUIDMapping mapping : uuidWrappers) {
                statement.setString(1, mapping.uuid().toString());
                statement.setString(2, mapping.username());
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public @NonNull List<UUIDMapping> getAll() {
        LinkedList<UUIDMapping> mappings = new LinkedList<UUIDMapping>();
        try (PreparedStatement statement = this.getConnection().prepareStatement("SELECT * FROM `usercache`");
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                mappings.add(new UUIDMapping(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappings;
    }
}

