/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.HybridPlotManager;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.google.Inject;
import org.checkerframework.checker.nullness.qual.NonNull;

@CommandDeclaration(command="regenallroads", aliases={"rgar"}, usage="/plot regenallroads <world> [height]", category=CommandCategory.ADMINISTRATION, requiredType=RequiredType.CONSOLE, permission="plots.regenallroads")
public class RegenAllRoads
extends SubCommand {
    private final PlotAreaManager plotAreaManager;
    private final HybridUtils hybridUtils;

    @Inject
    public RegenAllRoads(@NonNull PlotAreaManager plotAreaManager, @NonNull HybridUtils hybridUtils) {
        this.plotAreaManager = plotAreaManager;
        this.hybridUtils = hybridUtils;
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        int height = 0;
        if (args.length == 2) {
            try {
                height = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException ignored) {
                player.sendMessage(TranslatableCaption.of("invalid.not_valid_number"), TagResolver.resolver("value", Tag.inserting(Component.text("(0, 256)"))));
                player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot regenallroads <world> [height]"))));
                return false;
            }
        } else if (args.length != 1) {
            player.sendMessage(TranslatableCaption.of("commandconfig.command_syntax"), TagResolver.resolver("value", Tag.inserting(Component.text("/plot regenallroads <world> [height]"))));
            return false;
        }
        PlotArea area = this.plotAreaManager.getPlotAreaByString(args[0]);
        if (area == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_valid_plot_world"), TagResolver.resolver("value", Tag.inserting(Component.text(args[0]))));
            return false;
        }
        PlotManager manager = area.getPlotManager();
        if (!(manager instanceof HybridPlotManager)) {
            player.sendMessage(TranslatableCaption.of("errors.invalid_plot_world"), new TagResolver[0]);
            return false;
        }
        player.sendMessage(TranslatableCaption.of("debugroadregen.schematic"), TagResolver.resolver("command", Tag.inserting(Component.text("/plot createroadschematic"))));
        player.sendMessage(TranslatableCaption.of("debugroadregen.regenallroads_started"), new TagResolver[0]);
        boolean result = this.hybridUtils.scheduleRoadUpdate(area, height);
        if (!result) {
            player.sendMessage(TranslatableCaption.of("debugexec.mass_schematic_update_in_progress"), new TagResolver[0]);
            return false;
        }
        return true;
    }
}

