/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.key;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.configuration.adventure.key.KeyImpl;
import com.plotsquared.core.configuration.adventure.key.Keyed;
import com.plotsquared.core.configuration.adventure.key.Namespaced;
import com.plotsquared.core.configuration.examination.Examinable;
import com.plotsquared.core.configuration.examination.ExaminableProperty;
import com.plotsquared.core.intellij.annotations.annotations.Pattern;
import java.util.Comparator;
import java.util.stream.Stream;

public interface Key
extends Comparable<Key>,
Examinable,
Namespaced,
Keyed {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final char DEFAULT_SEPARATOR = ':';

    @NotNull
    public static Key key(@NotNull @Pattern(value="([a-z0-9_\\-.]+:)?[a-z0-9_\\-./]+") String string) {
        return Key.key(string, ':');
    }

    @NotNull
    public static Key key(@NotNull String string, char character) {
        int index = string.indexOf(character);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.key(namespace, value);
    }

    @NotNull
    public static Key key(@NotNull Namespaced namespaced, @NotNull @Pattern(value="[a-z0-9_\\-./]+") String value) {
        return Key.key(namespaced.namespace(), value);
    }

    @NotNull
    public static Key key(@NotNull @Pattern(value="[a-z0-9_\\-.]+") String namespace, @NotNull @Pattern(value="[a-z0-9_\\-./]+") String value) {
        return new KeyImpl(namespace, value);
    }

    @NotNull
    public static Comparator<? super Key> comparator() {
        return KeyImpl.COMPARATOR;
    }

    public static boolean parseable(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int index = string.indexOf(58);
        String namespace = index >= 1 ? string.substring(0, index) : MINECRAFT_NAMESPACE;
        String value = index >= 0 ? string.substring(index + 1) : string;
        return Key.parseableNamespace(namespace) && Key.parseableValue(value);
    }

    public static boolean parseableNamespace(@NotNull String namespace) {
        int length = namespace.length();
        for (int i = 0; i < length; ++i) {
            if (Key.allowedInNamespace(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean parseableValue(@NotNull String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            if (Key.allowedInValue(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean allowedInNamespace(char character) {
        return KeyImpl.allowedInNamespace(character);
    }

    public static boolean allowedInValue(char character) {
        return KeyImpl.allowedInValue(character);
    }

    @Override
    @NotNull
    public String namespace();

    @NotNull
    public String value();

    @NotNull
    public String asString();

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("namespace", this.namespace()), ExaminableProperty.of("value", this.value()));
    }

    @Override
    default public int compareTo(@NotNull Key that) {
        return Key.comparator().compare(this, that);
    }

    @Override
    @NotNull
    default public Key key() {
        return this;
    }
}

