/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.configuration.adventure.text.format;

import com.plotsquared.core.annotations.annotations.ApiStatus;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.annotations.annotations.Unmodifiable;
import com.plotsquared.core.configuration.adventure.key.Key;
import com.plotsquared.core.configuration.adventure.text.event.ClickEvent;
import com.plotsquared.core.configuration.adventure.text.event.HoverEvent;
import com.plotsquared.core.configuration.adventure.text.format.DecorationMap;
import com.plotsquared.core.configuration.adventure.text.format.TextColor;
import com.plotsquared.core.configuration.adventure.text.format.TextDecoration;
import java.util.EnumMap;
import java.util.Map;

@ApiStatus.NonExtendable
public interface StyleGetter {
    @Nullable
    public Key font();

    @Nullable
    public TextColor color();

    default public boolean hasDecoration(@NotNull TextDecoration decoration) {
        return this.decoration(decoration) == TextDecoration.State.TRUE;
    }

    public @NotNull TextDecoration.State decoration(@NotNull TextDecoration var1);

    default public @Unmodifiable @NotNull Map<TextDecoration, TextDecoration.State> decorations() {
        EnumMap<TextDecoration, TextDecoration.State> decorations = new EnumMap<TextDecoration, TextDecoration.State>(TextDecoration.class);
        for (TextDecoration decoration : DecorationMap.DECORATIONS) {
            TextDecoration.State value = this.decoration(decoration);
            decorations.put(decoration, value);
        }
        return decorations;
    }

    @Nullable
    public ClickEvent clickEvent();

    @Nullable
    public HoverEvent<?> hoverEvent();

    @Nullable
    public String insertion();
}

