/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class Headers {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    private Headers() {
    }

    static Headers newInstance() {
        return new Headers();
    }

    void addHeader(@NotNull String key, @NotNull String value) {
        Objects.requireNonNull(key, "Key may not be null");
        Objects.requireNonNull(value, "Value may not be null");
        key = key.toLowerCase();
        if (this.headers.containsKey(key)) {
            this.headers.get(key).add(value);
        } else {
            LinkedList<String> headers = new LinkedList<String>();
            headers.add(value);
            this.headers.put(key, headers);
        }
    }

    @NotNull
    List<String> getHeaders(@NotNull String key) {
        Objects.requireNonNull(key, "Key may not be null");
        List<String> headers = this.headers.get(key.toLowerCase());
        if (headers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(headers);
    }

    @NotNull
    String getHeader(@NotNull String key) {
        return Objects.requireNonNull(this.getOrDefault(key, ""));
    }

    @Nullable
    String getOrDefault(@NotNull String key, @Nullable String defaultString) {
        List<String> headers = this.getHeaders(key);
        if (headers.isEmpty()) {
            return defaultString;
        }
        return headers.get(headers.size() - 1);
    }

    @NotNull
    Collection<String> getHeaders() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }
}

