/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.http;

import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.annotations.annotations.Nullable;
import com.plotsquared.core.http.ClientSettings;
import com.plotsquared.core.http.EntityMapper;
import com.plotsquared.core.http.HttpMethod;
import com.plotsquared.core.http.HttpRequest;
import com.plotsquared.core.http.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class HttpClient {
    private final EntityMapper mapper = new EntityMapper();
    private final ClientSettings settings;

    private HttpClient(@NotNull ClientSettings settings) {
        this.settings = Objects.requireNonNull(settings);
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NotNull
    public WrappedRequestBuilder get(@NotNull String url) {
        Objects.requireNonNull(url, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.GET, url);
    }

    @NotNull
    public WrappedRequestBuilder post(@NotNull String url) {
        Objects.requireNonNull(url, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.POST, url);
    }

    @NotNull
    public WrappedRequestBuilder put(@NotNull String url) {
        Objects.requireNonNull(url, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.PUT, url);
    }

    @NotNull
    public WrappedRequestBuilder head(@NotNull String url) {
        Objects.requireNonNull(url, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.HEAD, url);
    }

    @NotNull
    public WrappedRequestBuilder delete(@NotNull String url) {
        Objects.requireNonNull(url, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.DELETE, url);
    }

    @NotNull
    public WrappedRequestBuilder patch(@NotNull String url) {
        Objects.requireNonNull(url, "URL may not be null");
        return new WrappedRequestBuilder(HttpMethod.PATCH, url);
    }

    @NotNull
    public EntityMapper getMapper() {
        return this.mapper;
    }

    public static final class Builder {
        private final ClientSettings settings = new ClientSettings();

        private Builder() {
        }

        @NotNull
        public Builder withBaseURL(@NotNull String baseURL) {
            Objects.requireNonNull(baseURL, "Base URL may not be null");
            if (baseURL.endsWith("/")) {
                this.settings.setBaseURL(baseURL.substring(0, baseURL.length() - 1));
            } else {
                this.settings.setBaseURL(baseURL);
            }
            return this;
        }

        @NotNull
        public Builder withEntityMapper(@Nullable EntityMapper entityMapper) {
            this.settings.setEntityMapper(entityMapper);
            return this;
        }

        @NotNull
        public Builder withDecorator(@NotNull Consumer<WrappedRequestBuilder> decorator) {
            this.settings.addDecorator(Objects.requireNonNull(decorator, "Decorator may not be null"));
            return this;
        }

        public HttpClient build() {
            return new HttpClient(this.settings);
        }
    }

    public final class WrappedRequestBuilder {
        private final HttpRequest.Builder builder = HttpRequest.newBuilder();
        private final Map<Integer, Consumer<HttpResponse>> consumers = new HashMap<Integer, Consumer<HttpResponse>>();
        private Consumer<HttpResponse> other = response -> {};
        private Consumer<Throwable> exceptionHandler = null;

        private WrappedRequestBuilder(@NotNull HttpMethod method, String url) {
            if (url.startsWith("/")) {
                url = url.length() == 1 ? "" : url.substring(1);
            }
            url = HttpClient.this.settings.getBaseURL() + '/' + url;
            try {
                URL javaURL = new URL(url);
                this.builder.withURL(javaURL);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.builder.withMethod(method);
            if (HttpClient.this.settings.getEntityMapper() != null) {
                this.builder.withMapper(HttpClient.this.settings.getEntityMapper());
            }
        }

        @NotNull
        public WrappedRequestBuilder withInput(@NotNull Supplier<Object> input) {
            this.builder.withInput(input);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder withMapper(@NotNull EntityMapper mapper) {
            this.builder.withMapper(mapper);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder withHeader(@NotNull String key, @NotNull String value) {
            this.builder.withHeader(key, value);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder onStatus(int code, @NotNull Consumer<HttpResponse> responseConsumer) {
            this.consumers.put(code, responseConsumer);
            return this;
        }

        @NotNull
        public WrappedRequestBuilder onRemaining(@NotNull Consumer<HttpResponse> responseConsumer) {
            this.other = responseConsumer;
            return this;
        }

        @NotNull
        public WrappedRequestBuilder onException(@NotNull Consumer<Throwable> consumer) {
            this.exceptionHandler = consumer;
            this.builder.onException(consumer);
            return this;
        }

        @Nullable
        public HttpResponse execute() {
            for (Consumer<WrappedRequestBuilder> decorator : HttpClient.this.settings.getRequestDecorators()) {
                decorator.accept(this);
            }
            try {
                HttpResponse response;
                Throwable[] throwables = new Throwable[1];
                if (this.exceptionHandler == null) {
                    this.builder.onException(e -> {
                        throwables[0] = e;
                    });
                }
                if ((response = this.builder.build().executeRequest()) != null) {
                    Consumer<HttpResponse> responseConsumer = this.consumers.getOrDefault(response.getStatusCode(), this.other);
                    responseConsumer.accept(response);
                }
                if (throwables[0] != null) {
                    if (throwables[0] instanceof RuntimeException) {
                        throw (RuntimeException)throwables[0];
                    }
                    throw new RuntimeException(throwables[0]);
                }
                return response;
            }
            catch (Exception e2) {
                if (this.exceptionHandler == null) {
                    if (e2 instanceof RuntimeException) {
                        throw (RuntimeException)e2;
                    }
                    throw new RuntimeException(e2);
                }
                return null;
            }
        }
    }
}

