/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.command.Template;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.FileBytes;
import com.sk89q.worldedit.function.pattern.Pattern;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlotManager {
    private final PlotArea plotArea;

    public PlotManager(@NonNull PlotArea plotArea) {
        this.plotArea = plotArea;
    }

    public abstract PlotId getPlotIdAbs(int var1, int var2, int var3);

    public abstract PlotId getPlotId(int var1, int var2, int var3);

    public abstract Location getPlotBottomLocAbs(@NonNull PlotId var1);

    public abstract Location getPlotTopLocAbs(@NonNull PlotId var1);

    public abstract boolean clearPlot(@NonNull Plot var1, @Nullable Runnable var2, @Nullable PlotPlayer<?> var3, @Nullable QueueCoordinator var4);

    public abstract boolean claimPlot(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean unClaimPlot(@NonNull Plot var1, @Nullable Runnable var2, @Nullable QueueCoordinator var3);

    public abstract Location getSignLoc(@NonNull Plot var1);

    public abstract String[] getPlotComponents(@NonNull PlotId var1);

    public abstract boolean setComponent(@NonNull PlotId var1, @NonNull String var2, @NonNull Pattern var3, @Nullable PlotPlayer<?> var4, @Nullable QueueCoordinator var5);

    public abstract boolean createRoadEast(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean createRoadSouth(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean createRoadSouthEast(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean removeRoadEast(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean removeRoadSouth(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean removeRoadSouthEast(@NonNull Plot var1, @Nullable QueueCoordinator var2);

    public abstract boolean startPlotMerge(@NonNull List<PlotId> var1, @Nullable QueueCoordinator var2);

    public abstract boolean startPlotUnlink(@NonNull List<PlotId> var1, @Nullable QueueCoordinator var2);

    public abstract boolean finishPlotMerge(@NonNull List<PlotId> var1, @Nullable QueueCoordinator var2);

    public abstract boolean finishPlotUnlink(@NonNull List<PlotId> var1, @Nullable QueueCoordinator var2);

    public void exportTemplate() throws IOException {
        HashSet<FileBytes> files = new HashSet<FileBytes>(Collections.singletonList(new FileBytes(Settings.Paths.TEMPLATES + "/tmp-data.yml", Template.getBytes(this.plotArea))));
        Template.zipAll(this.plotArea.getWorldName(), files);
    }

    public boolean regenerateAllPlotWalls(@Nullable QueueCoordinator queue) {
        boolean success = true;
        for (Plot plot : this.plotArea.getPlots()) {
            if (plot.hasOwner()) {
                success &= this.claimPlot(plot, queue);
                continue;
            }
            success &= this.unClaimPlot(plot, null, queue);
        }
        return success;
    }
}

