/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.PlotFlag;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class BooleanFlag<F extends PlotFlag<Boolean, F>>
extends PlotFlag<Boolean, F> {
    private static final Collection<String> positiveValues = Arrays.asList("1", "yes", "allow", "true");
    private static final Collection<String> negativeValues = Arrays.asList("0", "no", "deny", "disallow", "false");

    protected BooleanFlag(boolean value, Caption description) {
        super(value, TranslatableCaption.of("flags.flag_category_boolean"), description);
    }

    protected BooleanFlag(Caption description) {
        this(false, description);
    }

    @Override
    public F parse(@NonNull String input) throws FlagParseException {
        if (positiveValues.contains(input.toLowerCase(Locale.ENGLISH))) {
            return this.flagOf(true);
        }
        if (negativeValues.contains(input.toLowerCase(Locale.ENGLISH))) {
            return this.flagOf(false);
        }
        throw new FlagParseException(this, input, TranslatableCaption.of("flags.flag_error_boolean"), new TagResolver[0]);
    }

    @Override
    public F merge(@NonNull Boolean newValue) {
        return this.flagOf((Boolean)this.getValue() != false || newValue != false);
    }

    @Override
    public String getExample() {
        return "true";
    }

    @Override
    public String toString() {
        return ((Boolean)this.getValue()).toString();
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("true", "false");
    }
}

