/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.services;

import com.plotsquared.core.geantyref.TypeToken;
import com.plotsquared.core.services.AnnotatedMethodService;
import com.plotsquared.core.services.annotations.ServiceImplementation;
import com.plotsquared.core.services.types.Service;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

enum AnnotatedMethodServiceFactory {
    INSTANCE;


    @NonNull Map<? extends Service<?, ?>, TypeToken<? extends Service<?, ?>>> lookupServices(@NonNull Object instance) throws Exception {
        HashMap map = new HashMap();
        Class<?> clazz = instance.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            ServiceImplementation serviceImplementation = method.getAnnotation(ServiceImplementation.class);
            if (serviceImplementation == null) continue;
            if (method.getParameterCount() != 1) {
                throw new IllegalArgumentException(String.format("Method '%s' in class '%s' has wrong parameter count. Expected 1, got %d", method.getName(), instance.getClass().getCanonicalName(), method.getParameterCount()));
            }
            map.put(new AnnotatedMethodService(instance, method), TypeToken.get(serviceImplementation.value()));
        }
        return map;
    }
}

