/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.task;

import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EventDispatcher;
import java.util.concurrent.Callable;

public final class AutoClaimFinishTask
implements Callable<Boolean> {
    private final PlotPlayer<?> player;
    private final Plot plot;
    private final PlotArea area;
    private final String schematic;
    private final EventDispatcher eventDispatcher;

    public AutoClaimFinishTask(PlotPlayer<?> player, Plot plot, PlotArea area, String schematic, EventDispatcher eventDispatcher) {
        this.player = player;
        this.plot = plot;
        this.area = area;
        this.schematic = schematic;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public Boolean call() {
        try (MetaDataAccess<Boolean> autoAccess = this.player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_AUTO);){
            autoAccess.remove();
        }
        if (this.plot == null) {
            this.player.sendMessage(TranslatableCaption.of("errors.no_free_plots"), new TagResolver[0]);
            return false;
        }
        this.plot.claim(this.player, true, this.schematic, false, true);
        this.eventDispatcher.callPostAuto(this.player, this.plot);
        if (this.area.isAutoMerge()) {
            PlotMergeEvent event = this.eventDispatcher.callMerge(this.plot, Direction.ALL, Integer.MAX_VALUE, this.player);
            if (event.getEventResult() == Result.DENY) {
                this.player.sendMessage(TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Auto Merge"))));
            } else if (this.plot.getPlotModificationManager().autoMerge(event.getDir(), event.getMax(), this.player.getUUID(), this.player, true)) {
                this.eventDispatcher.callPostMerge(this.player, this.plot);
            }
        }
        return true;
    }
}

