/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.assistedinject;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.assistedinject.Assisted;
import com.plotsquared.google.assistedinject.AssistedConstructor;
import com.plotsquared.google.assistedinject.AssistedInject;
import com.plotsquared.google.assistedinject.BindingCollector;
import com.plotsquared.google.assistedinject.FactoryProvider2;
import com.plotsquared.google.assistedinject.Parameter;
import com.plotsquared.google.assistedinject.ParameterListKey;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.HasDependencies;
import com.plotsquared.google.spi.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Deprecated
public class FactoryProvider<F>
implements Provider<F>,
HasDependencies {
    private Injector injector;
    private final TypeLiteral<F> factoryType;
    private final TypeLiteral<?> implementationType;
    private final Map<Method, AssistedConstructor<?>> factoryMethodToConstructor;

    public static <F> Provider<F> newFactory(Class<F> factoryType, Class<?> implementationType) {
        return FactoryProvider.newFactory(TypeLiteral.get(factoryType), TypeLiteral.get(implementationType));
    }

    public static <F> Provider<F> newFactory(TypeLiteral<F> factoryType, TypeLiteral<?> implementationType) {
        Map<Method, AssistedConstructor<?>> factoryMethodToConstructor = FactoryProvider.createMethodMapping(factoryType, implementationType);
        if (!factoryMethodToConstructor.isEmpty()) {
            return new FactoryProvider<F>(factoryType, implementationType, factoryMethodToConstructor);
        }
        BindingCollector collector = new BindingCollector();
        Errors errors = new Errors();
        Key<?> implementationKey = Key.get(implementationType);
        try {
            for (Method method : factoryType.getRawType().getMethods()) {
                Key<?> returnType = Annotations.getKey(factoryType.getReturnType(method), method, method.getAnnotations(), errors);
                if (implementationKey.equals(returnType)) continue;
                collector.addBinding(returnType, implementationType);
            }
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(e.getErrors().getMessages());
        }
        return new FactoryProvider2<F>(Key.get(factoryType), collector, null);
    }

    private FactoryProvider(TypeLiteral<F> factoryType, TypeLiteral<?> implementationType, Map<Method, AssistedConstructor<?>> factoryMethodToConstructor) {
        this.factoryType = factoryType;
        this.implementationType = implementationType;
        this.factoryMethodToConstructor = factoryMethodToConstructor;
        this.checkDeclaredExceptionsMatch();
    }

    @Inject
    void setInjectorAndCheckUnboundParametersAreInjectable(Injector injector) {
        this.injector = injector;
        for (AssistedConstructor<?> c : this.factoryMethodToConstructor.values()) {
            for (Parameter p : c.getAllParameters()) {
                if (p.isProvidedByFactory() || this.paramCanBeInjected(p, injector)) continue;
                throw FactoryProvider.newConfigurationException("Parameter of type '%s' is not injectable or annotated with @Assisted for Constructor '%s'", p, c);
            }
        }
    }

    private void checkDeclaredExceptionsMatch() {
        for (Map.Entry<Method, AssistedConstructor<?>> entry : this.factoryMethodToConstructor.entrySet()) {
            for (Class<?> constructorException : entry.getValue().getDeclaredExceptions()) {
                if (this.isConstructorExceptionCompatibleWithFactoryExeception(constructorException, entry.getKey().getExceptionTypes())) continue;
                throw FactoryProvider.newConfigurationException("Constructor %s declares an exception, but no compatible exception is thrown by the factory method %s", entry.getValue(), entry.getKey());
            }
        }
    }

    private boolean isConstructorExceptionCompatibleWithFactoryExeception(Class<?> constructorException, Class<?>[] factoryExceptions) {
        for (Class<?> factoryException : factoryExceptions) {
            if (!factoryException.isAssignableFrom(constructorException)) continue;
            return true;
        }
        return false;
    }

    private boolean paramCanBeInjected(Parameter parameter, Injector injector) {
        return parameter.isBound(injector);
    }

    private static Map<Method, AssistedConstructor<?>> createMethodMapping(TypeLiteral<?> factoryType, TypeLiteral<?> implementationType) {
        ArrayList constructors = Lists.newArrayList();
        for (Constructor<?> constructor : implementationType.getRawType().getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(AssistedInject.class)) continue;
            AssistedConstructor<?> assistedConstructor = AssistedConstructor.create(constructor, implementationType.getParameterTypes(constructor));
            constructors.add(assistedConstructor);
        }
        if (constructors.isEmpty()) {
            return ImmutableMap.of();
        }
        Method[] factoryMethods = factoryType.getRawType().getMethods();
        if (constructors.size() != factoryMethods.length) {
            throw FactoryProvider.newConfigurationException("Constructor mismatch: %s has %s @AssistedInject constructors, factory %s has %s creation methods", implementationType, constructors.size(), factoryType, factoryMethods.length);
        }
        HashMap paramsToConstructor = Maps.newHashMap();
        for (AssistedConstructor c : constructors) {
            if (paramsToConstructor.containsKey(c.getAssistedParameters())) {
                throw new RuntimeException("Duplicate constructor, " + c);
            }
            paramsToConstructor.put(c.getAssistedParameters(), c);
        }
        HashMap result = Maps.newHashMap();
        for (Method method : factoryMethods) {
            if (!method.getReturnType().isAssignableFrom(implementationType.getRawType())) {
                throw FactoryProvider.newConfigurationException("Return type of method %s is not assignable from %s", method, implementationType);
            }
            ArrayList parameterTypes = Lists.newArrayList();
            for (TypeLiteral<?> typeLiteral : factoryType.getParameterTypes(method)) {
                parameterTypes.add(typeLiteral.getType());
            }
            ParameterListKey methodParams = new ParameterListKey(parameterTypes);
            if (!paramsToConstructor.containsKey(methodParams)) {
                throw FactoryProvider.newConfigurationException("%s has no @AssistInject constructor that takes the @Assisted parameters %s in that order. @AssistInject constructors are %s", implementationType, methodParams, paramsToConstructor.values());
            }
            method.getParameterAnnotations();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation parameterAnnotation : parameterAnnotations = annotationArray[i]) {
                    if (parameterAnnotation.annotationType() != Assisted.class) continue;
                    throw FactoryProvider.newConfigurationException("Factory method %s has an @Assisted parameter, which is incompatible with the deprecated @AssistedInject annotation. Please replace @AssistedInject with @Inject on the %s constructor.", method, implementationType);
                }
            }
            AssistedConstructor assistedConstructor = (AssistedConstructor)paramsToConstructor.remove(methodParams);
            result.put(method, assistedConstructor);
        }
        return result;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        ArrayList dependencies = Lists.newArrayList();
        for (AssistedConstructor<?> constructor : this.factoryMethodToConstructor.values()) {
            for (Parameter parameter : constructor.getAllParameters()) {
                if (parameter.isProvidedByFactory()) continue;
                dependencies.add(Dependency.get(parameter.getPrimaryBindingKey()));
            }
        }
        return ImmutableSet.copyOf((Collection)dependencies);
    }

    @Override
    public F get() {
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] creationArgs) throws Throwable {
                if (method.getDeclaringClass().equals(Object.class)) {
                    if ("equals".equals(method.getName())) {
                        return proxy == creationArgs[0];
                    }
                    if ("hashCode".equals(method.getName())) {
                        return System.identityHashCode(proxy);
                    }
                    return method.invoke((Object)this, creationArgs);
                }
                AssistedConstructor constructor = (AssistedConstructor)FactoryProvider.this.factoryMethodToConstructor.get(method);
                Object[] constructorArgs = this.gatherArgsForConstructor(constructor, creationArgs);
                Object objectToReturn = constructor.newInstance(constructorArgs);
                FactoryProvider.this.injector.injectMembers(objectToReturn);
                return objectToReturn;
            }

            public Object[] gatherArgsForConstructor(AssistedConstructor<?> constructor, Object[] factoryArgs) {
                int numParams = constructor.getAllParameters().size();
                int argPosition = 0;
                Object[] result = new Object[numParams];
                for (int i = 0; i < numParams; ++i) {
                    Parameter parameter = constructor.getAllParameters().get(i);
                    if (parameter.isProvidedByFactory()) {
                        result[i] = factoryArgs[argPosition];
                        ++argPosition;
                        continue;
                    }
                    result[i] = parameter.getValue(FactoryProvider.this.injector);
                }
                return result;
            }
        };
        Class<F> factoryRawType = this.factoryType.getRawType();
        return factoryRawType.cast(Proxy.newProxyInstance(factoryRawType.getClassLoader(), new Class[]{factoryRawType}, invocationHandler));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.factoryType, this.implementationType});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FactoryProvider)) {
            return false;
        }
        FactoryProvider other = (FactoryProvider)obj;
        return this.factoryType.equals(other.factoryType) && this.implementationType.equals(other.implementationType);
    }

    private static ConfigurationException newConfigurationException(String format, Object ... args) {
        return new ConfigurationException((Iterable<Message>)ImmutableSet.of((Object)new Message(Errors.format(format, args))));
    }
}

