/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.AbstractBindingProcessor;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.BoundProviderFactory;
import com.plotsquared.google.internal.ConstantFactory;
import com.plotsquared.google.internal.ConstructorBindingImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.ExposedBindingImpl;
import com.plotsquared.google.internal.ExposedKeyFactory;
import com.plotsquared.google.internal.FactoryProxy;
import com.plotsquared.google.internal.Initializable;
import com.plotsquared.google.internal.Initializer;
import com.plotsquared.google.internal.InstanceBindingImpl;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalFactoryToInitializableAdapter;
import com.plotsquared.google.internal.InternalProviderInstanceBindingImpl;
import com.plotsquared.google.internal.LinkedBindingImpl;
import com.plotsquared.google.internal.LinkedProviderBindingImpl;
import com.plotsquared.google.internal.ProcessedBindingData;
import com.plotsquared.google.internal.ProviderInstanceBindingImpl;
import com.plotsquared.google.internal.ProviderMethod;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.ConstructorBinding;
import com.plotsquared.google.spi.ConvertedConstantBinding;
import com.plotsquared.google.spi.ExposedBinding;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.InstanceBinding;
import com.plotsquared.google.spi.LinkedKeyBinding;
import com.plotsquared.google.spi.PrivateElements;
import com.plotsquared.google.spi.ProviderBinding;
import com.plotsquared.google.spi.ProviderInstanceBinding;
import com.plotsquared.google.spi.ProviderKeyBinding;
import com.plotsquared.google.spi.UntargettedBinding;
import java.util.Set;

final class BindingProcessor
extends AbstractBindingProcessor {
    private final Initializer initializer;

    BindingProcessor(Errors errors, Initializer initializer, ProcessedBindingData processedBindingData) {
        super(errors, processedBindingData);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        Class<T> rawType = command.getKey().getTypeLiteral().getRawType();
        if (Void.class.equals(rawType)) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getUserSuppliedProvider() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        return (Boolean)command.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)command){

            @Override
            public Boolean visit(ConstructorBinding<? extends T> binding) {
                this.prepareBinding();
                try {
                    ConstructorBindingImpl onInjector = ConstructorBindingImpl.create(BindingProcessor.this.injector, this.key, binding.getConstructor(), this.source, this.scoping, BindingProcessor.this.errors, false, false);
                    this.scheduleInitialization(onInjector);
                    BindingProcessor.this.putBinding(onInjector);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            public Boolean visit(InstanceBinding<? extends T> binding) {
                this.prepareBinding();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, instance, binding, this.source, injectionPoints);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, injectionPoints, instance));
                return true;
            }

            @Override
            public Boolean visit(ProviderInstanceBinding<? extends T> binding) {
                this.prepareBinding();
                com.plotsquared.core.annotation.inject.Provider provider = binding.getUserSuppliedProvider();
                if (provider instanceof InternalProviderInstanceBindingImpl.Factory) {
                    InternalProviderInstanceBindingImpl.Factory asProviderMethod = (InternalProviderInstanceBindingImpl.Factory)provider;
                    return this.visitInternalProviderInstanceBindingFactory(asProviderMethod);
                }
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, provider, null, this.source, injectionPoints);
                InternalFactoryToInitializableAdapter factory = new InternalFactoryToInitializableAdapter(initializable, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, provider, injectionPoints));
                return true;
            }

            @Override
            public Boolean visit(ProviderKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                BindingProcessor.this.processedBindingData.addCreationListener(boundProviderFactory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, boundProviderFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, providerKey));
                return true;
            }

            @Override
            public Boolean visit(LinkedKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key linkedKey = binding.getLinkedKey();
                if (this.key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding(this.key, linkedKey);
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, this.key, linkedKey, this.source);
                BindingProcessor.this.processedBindingData.addCreationListener(factory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, linkedKey));
                return true;
            }

            private Boolean visitInternalProviderInstanceBindingFactory(InternalProviderInstanceBindingImpl.Factory<T> provider) {
                InternalProviderInstanceBindingImpl binding = new InternalProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, provider, Scoping.scope(this.key, BindingProcessor.this.injector, provider, this.source, this.scoping), this.scoping);
                switch (binding.getInitializationTiming()) {
                    case DELAYED: {
                        this.scheduleDelayedInitialization(binding);
                        break;
                    }
                    case EAGER: {
                        this.scheduleInitialization(binding);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                BindingProcessor.this.putBinding(binding);
                return true;
            }

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                return false;
            }

            @Override
            public Boolean visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding) {
                throw new IllegalStateException("BindingProcessor should override all visitations");
            }
        });
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.processedBindingData.addCreationListener(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>(this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }
}

