/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.core.annotation.inject.Provider;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.DelayedInitialize;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.Elements;
import com.plotsquared.google.spi.HasDependencies;
import com.plotsquared.google.spi.ProviderKeyBinding;
import java.util.Set;

final class LinkedProviderBindingImpl<T>
extends BindingImpl<T>
implements ProviderKeyBinding<T>,
HasDependencies,
DelayedInitialize {
    final Key<? extends Provider<? extends T>> providerKey;
    final DelayedInitialize delayedInitializer;

    private LinkedProviderBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey, DelayedInitialize delayedInitializer) {
        super(injector, key, source, internalFactory, scoping);
        this.providerKey = providerKey;
        this.delayedInitializer = delayedInitializer;
    }

    public LinkedProviderBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey) {
        this(injector, key, source, internalFactory, scoping, providerKey, null);
    }

    LinkedProviderBindingImpl(Object source, Key<T> key, Scoping scoping, Key<? extends Provider<? extends T>> providerKey) {
        super(source, key, scoping);
        this.providerKey = providerKey;
        this.delayedInitializer = null;
    }

    static <T> LinkedProviderBindingImpl<T> createWithInitializer(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Key<? extends Provider<? extends T>> providerKey, DelayedInitialize delayedInitializer) {
        return new LinkedProviderBindingImpl<T>(injector, key, source, internalFactory, scoping, providerKey, delayedInitializer);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Key<? extends Provider<? extends T>> getProviderKey() {
        return this.providerKey;
    }

    @Override
    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        if (this.delayedInitializer != null) {
            this.delayedInitializer.initialize(injector, errors);
        }
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return ImmutableSet.of(Dependency.get(this.providerKey));
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new LinkedProviderBindingImpl(this.getSource(), this.getKey(), scoping, this.providerKey);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new LinkedProviderBindingImpl<T>(this.getSource(), key, this.getScoping(), this.providerKey);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(Elements.withTrustedSource(GuiceInternal.GUICE_INTERNAL, binder, this.getSource()).bind(this.getKey()).toProvider(this.getProviderKey()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ProviderKeyBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", (Object)this.getScoping()).add("provider", this.providerKey).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinkedProviderBindingImpl) {
            LinkedProviderBindingImpl o = (LinkedProviderBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.providerKey, o.providerKey);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping(), this.providerKey});
    }
}

