/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.core.annotation.inject.Provider;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.Dependency;

abstract class ProviderInternalFactory<T>
implements InternalFactory<T> {
    protected final Object source;

    ProviderInternalFactory(Object source) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T circularGet(final Provider<? extends T> provider, InternalContext context, final Dependency<?> dependency, @Nullable ProvisionListenerStackCallback<T> provisionCallback) throws InternalProvisionException {
        final ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            Class<?> expectedType = dependency.getKey().getTypeLiteral().getRawType();
            Object proxyType = constructionContext.createProxy(context.getInjectorOptions(), expectedType);
            return (T)proxyType;
        }
        constructionContext.startConstruction();
        try {
            if (provisionCallback == null) {
                T t = this.provision(provider, dependency, constructionContext);
                return t;
            }
            T t = provisionCallback.provision(context, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() throws InternalProvisionException {
                    return ProviderInternalFactory.this.provision(provider, dependency, constructionContext);
                }
            });
            return t;
        }
        finally {
            constructionContext.removeCurrentReference();
            constructionContext.finishConstruction();
        }
    }

    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        T t = provider.get();
        if (t == null && !dependency.isNullable()) {
            InternalProvisionException.onNullInjectedIntoNonNullableDependency(this.source, dependency);
        }
        constructionContext.setProxyDelegates(t);
        return t;
    }
}

