/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.Binding;
import com.plotsquared.google.internal.AbstractBindingProcessor;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.ProcessedBindingData;
import com.plotsquared.google.spi.UntargettedBinding;

class UntargettedBindingProcessor
extends AbstractBindingProcessor {
    UntargettedBindingProcessor(Errors errors, ProcessedBindingData processedBindingData) {
        super(errors, processedBindingData);
    }

    @Override
    public <T> Boolean visit(Binding<T> binding) {
        return (Boolean)binding.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)binding){

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                this.prepareBinding();
                if (this.key.getAnnotationType() != null) {
                    UntargettedBindingProcessor.this.errors.missingImplementationWithHint(this.key, UntargettedBindingProcessor.this.injector);
                    UntargettedBindingProcessor.this.putBinding(UntargettedBindingProcessor.this.invalidBinding(UntargettedBindingProcessor.this.injector, this.key, this.source));
                    return true;
                }
                try {
                    BindingImpl binding = UntargettedBindingProcessor.this.injector.createUninitializedBinding(this.key, this.scoping, this.source, UntargettedBindingProcessor.this.errors, false);
                    this.scheduleInitialization(binding);
                    UntargettedBindingProcessor.this.putBinding(binding);
                }
                catch (ErrorsException e) {
                    UntargettedBindingProcessor.this.errors.merge(e.getErrors());
                    UntargettedBindingProcessor.this.putBinding(UntargettedBindingProcessor.this.invalidBinding(UntargettedBindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding) {
                return false;
            }
        });
    }
}

