/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.prtree;

import com.plotsquared.prtree.DistanceCalculator;
import com.plotsquared.prtree.DistanceResult;
import com.plotsquared.prtree.MBR;
import com.plotsquared.prtree.MBRConverter;
import com.plotsquared.prtree.MinDist;
import com.plotsquared.prtree.MinDistComparator;
import com.plotsquared.prtree.Node;
import com.plotsquared.prtree.NodeBase;
import com.plotsquared.prtree.NodeFilter;
import java.util.List;
import java.util.PriorityQueue;

class InternalNode<T>
extends NodeBase<Node<T>, T> {
    public InternalNode(Object[] data) {
        super(data);
    }

    @Override
    public MBR computeMBR(MBRConverter<T> converter) {
        MBR ret = null;
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            ret = this.getUnion(ret, ((Node)this.get(i)).getMBR(converter));
        }
        return ret;
    }

    @Override
    public void expand(MBR mbr, MBRConverter<T> converter, List<T> found, List<Node<T>> nodesToExpand) {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            Node n = (Node)this.get(i);
            if (!mbr.intersects(n.getMBR(converter))) continue;
            nodesToExpand.add(n);
        }
    }

    @Override
    public void find(MBR mbr, MBRConverter<T> converter, List<T> result) {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            Node n = (Node)this.get(i);
            if (!mbr.intersects(n.getMBR(converter))) continue;
            n.find(mbr, converter, result);
        }
    }

    @Override
    public void nnExpand(DistanceCalculator<T> dc, NodeFilter<T> filter, List<DistanceResult<T>> drs, int maxHits, PriorityQueue<Node<T>> queue, MinDistComparator<T, Node<T>> mdc) {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            Node n = (Node)this.get(i);
            MBR mbr = n.getMBR(mdc.converter);
            double minDist = MinDist.get(mbr, mdc.p);
            int t = drs.size();
            if (t >= maxHits && !(minDist <= drs.get(t - 1).getDistance())) continue;
            queue.add(n);
        }
    }
}

