/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.command;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.CommandDeclaration;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.command.SubCommand;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.util.Permissions;
import com.plotsquared.core.util.task.RunnableVal2;
import com.plotsquared.core.util.task.RunnableVal3;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.Template;

@CommandDeclaration(usage="/plot swap <X;Z>", command="swap", aliases={"switch"}, category=CommandCategory.CLAIMING, requiredType=RequiredType.PLAYER)
public class Swap
extends SubCommand {
    @Override
    public CompletableFuture<Boolean> execute(PlotPlayer<?> player, String[] args, RunnableVal3<Command, Runnable, Runnable> confirm, RunnableVal2<Command, Command.CommandResult> whenDone) {
        Location location = player.getLocation();
        Plot plot1 = location.getPlotAbs();
        if (plot1 == null) {
            player.sendMessage(TranslatableCaption.of("errors.not_in_plot"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!plot1.isOwner(player.getUUID()) && !Permissions.hasPermission(player, Permission.PERMISSION_ADMIN)) {
            player.sendMessage(TranslatableCaption.of("permission.no_plot_perms"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (args.length != 1) {
            this.sendUsage(player);
            return CompletableFuture.completedFuture(false);
        }
        Plot plot2 = Plot.getPlotFromString(player, args[0], true);
        if (plot2 == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (plot1.equals(plot2)) {
            player.sendMessage(TranslatableCaption.of("invalid.origin_cant_be_target"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (!plot1.getArea().isCompatible(plot2.getArea())) {
            player.sendMessage(TranslatableCaption.of("errors.plotworld_incompatible"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        if (plot1.isMerged() || plot2.isMerged()) {
            player.sendMessage(TranslatableCaption.of("swap.swap_merged"), new Template[0]);
            return CompletableFuture.completedFuture(false);
        }
        String p1 = plot1.toString();
        String p2 = plot2.toString();
        return plot1.getPlotModificationManager().move(plot2, player, () -> {}, true).thenApply(result -> {
            if (result.booleanValue()) {
                player.sendMessage(TranslatableCaption.of("swap.swap_success"), Template.of("origin", p1), Template.of("target", p2));
                return true;
            }
            player.sendMessage(TranslatableCaption.of("swap.swap_overlap"), new Template[0]);
            return false;
        });
    }

    @Override
    public boolean onCommand(PlotPlayer<?> player, String[] args) {
        return true;
    }
}

