/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.MetaDataKey;
import com.plotsquared.core.player.PlotPlayer;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PersistentMetaDataAccess<T>
extends MetaDataAccess<T> {
    PersistentMetaDataAccess(@NonNull PlotPlayer<?> player, @NonNull MetaDataKey<T> metaDataKey,  @NonNull LockRepository.LockAccess lockAccess) {
        super(player, metaDataKey, lockAccess);
    }

    @Override
    public boolean isPresent() {
        this.checkClosed();
        return this.getPlayer().hasPersistentMeta(this.getMetaDataKey().toString());
    }

    @Override
    public @Nullable T remove() {
        this.checkClosed();
        Object old = this.getPlayer().removePersistentMeta(this.getMetaDataKey().toString());
        if (old == null) {
            return null;
        }
        return (T)old;
    }

    @Override
    public void set(@NonNull T value) {
        this.checkClosed();
        this.getPlayer().setPersistentMeta(this.getMetaDataKey(), value);
    }

    @Override
    public @NonNull Optional<T> get() {
        this.checkClosed();
        return Optional.ofNullable(this.getPlayer().getPersistentMeta(this.getMetaDataKey()));
    }
}

