/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableList;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.plot.comment.PlotComment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlotSettings {
    private boolean[] merged = new boolean[]{false, false, false, false};
    private String alias = "";
    private HashMap<UUID, Integer> ratings;
    private List<PlotComment> comments = null;
    private BlockLoc position;

    public boolean getMerged(int direction) {
        return this.merged[direction];
    }

    public Map<UUID, Integer> getRatings() {
        if (this.ratings == null) {
            this.ratings = new HashMap();
        }
        return this.ratings;
    }

    public void setRatings(HashMap<UUID, Integer> ratings) {
        this.ratings = ratings;
    }

    public boolean setMerged(int direction, boolean merged) {
        if (this.merged[direction] != merged) {
            this.merged[direction] = merged;
            return true;
        }
        return false;
    }

    public boolean setMerged(Direction direction, boolean merged) {
        if (Direction.ALL == direction) {
            throw new IllegalArgumentException("You cannot use Direction.ALL in this method!");
        }
        if (this.merged[direction.getIndex()] != merged) {
            this.merged[direction.getIndex()] = merged;
            return true;
        }
        return false;
    }

    public BlockLoc getPosition() {
        if (this.position == null) {
            return BlockLoc.MINY;
        }
        return this.position;
    }

    public void setPosition(BlockLoc position) {
        if (position != null && position.getX() == 0 && position.getY() == 0 && position.getZ() == 0) {
            position = null;
        }
        this.position = position;
    }

    public List<PlotComment> getComments(String inbox) {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return (List)this.comments.stream().filter(comment -> comment.inbox.equals(inbox)).collect(ImmutableList.toImmutableList());
    }

    boolean removeComment(PlotComment comment) {
        if (this.comments == null) {
            return false;
        }
        return this.comments.remove(comment);
    }

    void removeComments(List<PlotComment> comments) {
        comments.forEach(this::removeComment);
    }

    void addComment(PlotComment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<PlotComment>();
        }
        this.comments.add(comment);
    }

    public boolean[] getMerged() {
        return this.merged;
    }

    public void setMerged(boolean[] merged) {
        this.merged = merged;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setComments(List<PlotComment> comments) {
        this.comments = comments;
    }
}

