/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.expiration;

import com.google.inject.Inject;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.caption.Templates;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.PlotFlagAddEvent;
import com.plotsquared.core.events.PlotUnlinkEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.expiration.ExpiryTask;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.plot.flag.implementations.KeepFlag;
import com.plotsquared.core.plot.flag.implementations.ServerPlotFlag;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.RunnableVal3;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpireManager {
    @Deprecated(forRemoval=true, since="6.10.2")
    public static ExpireManager IMP;
    private final ConcurrentHashMap<UUID, Long> dates_cache;
    private final ConcurrentHashMap<UUID, Long> account_age_cache;
    private final EventDispatcher eventDispatcher;
    private final ArrayDeque<ExpiryTask> tasks = new ArrayDeque();
    private volatile HashSet<Plot> plotsToDelete;
    private int running;

    @Inject
    public ExpireManager(@NonNull EventDispatcher eventDispatcher) {
        this.dates_cache = new ConcurrentHashMap();
        this.account_age_cache = new ConcurrentHashMap();
        this.eventDispatcher = eventDispatcher;
    }

    public void addTask(ExpiryTask task) {
        this.tasks.add(task);
    }

    public void handleJoin(PlotPlayer<?> pp) {
        this.storeDate(pp.getUUID(), System.currentTimeMillis());
        if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty()) {
            for (Plot plot : pp.getPlots()) {
                this.plotsToDelete.remove(plot);
            }
        }
        this.confirmExpiry(pp);
    }

    public void handleEntry(PlotPlayer<?> pp, Plot plot) {
        if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty() && pp.hasPermission("plots.admin.command.autoclear") && this.plotsToDelete.contains(plot)) {
            if (!this.isExpired(new ArrayDeque<ExpiryTask>(this.tasks), plot).isEmpty()) {
                this.confirmExpiry(pp);
            } else {
                this.plotsToDelete.remove(plot);
                this.confirmExpiry(pp);
            }
        }
    }

    public long getAccountAge(UUID uuid) {
        Long value = this.account_age_cache.get(uuid);
        return value == null ? Long.MAX_VALUE : value;
    }

    public long getTimestamp(UUID uuid) {
        Long value = this.dates_cache.get(uuid);
        return value == null ? 0L : value;
    }

    public void updateExpired(Plot plot) {
        if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty() && this.plotsToDelete.contains(plot) && this.isExpired(new ArrayDeque<ExpiryTask>(this.tasks), plot).isEmpty()) {
            this.plotsToDelete.remove(plot);
        }
    }

    public void confirmExpiry(PlotPlayer<?> pp) {
        TaskManager.runTask(() -> {
            try (MetaDataAccess<Boolean> metaDataAccess = pp.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_IGNORE_EXPIRE_TASK);){
                if (metaDataAccess.isPresent()) {
                    return;
                }
                if (this.plotsToDelete != null && !this.plotsToDelete.isEmpty() && pp.hasPermission("plots.admin.command.autoclear")) {
                    int num = this.plotsToDelete.size();
                    while (!this.plotsToDelete.isEmpty()) {
                        Iterator<Plot> iter = this.plotsToDelete.iterator();
                        Plot current = iter.next();
                        if (!this.isExpired(new ArrayDeque<ExpiryTask>(this.tasks), current).isEmpty()) {
                            metaDataAccess.set(true);
                            current.getCenter(pp::teleport);
                            metaDataAccess.remove();
                            TranslatableCaption msg = TranslatableCaption.of("expiry.expired_options_clicky");
                            Template numTemplate = Template.of("num", String.valueOf(num));
                            Template areIsTemplate = Template.of("are_or_is", num > 1 ? "plots are" : "plot is");
                            Template list_cmd = Template.of("list_cmd", "/plot list expired");
                            Template plot = Template.of("plot", current.toString());
                            Template cmd_del = Template.of("cmd_del", "/plot delete");
                            Template cmd_keep_1d = Template.of("cmd_keep_1d", "/plot flag set keep 1d");
                            Template cmd_keep = Template.of("cmd_keep", "/plot flag set keep true");
                            Template cmd_no_show_expir = Template.of("cmd_no_show_expir", "/plot toggle clear-confirmation");
                            pp.sendMessage(msg, numTemplate, areIsTemplate, list_cmd, plot, cmd_del, cmd_keep_1d, cmd_keep, cmd_no_show_expir);
                            return;
                        }
                        iter.remove();
                    }
                    this.plotsToDelete.clear();
                }
            }
        });
    }

    public boolean cancelTask() {
        if (this.running != 2) {
            return false;
        }
        this.running = 1;
        return true;
    }

    public boolean runAutomatedTask() {
        return this.runTask(new RunnableVal3<Plot, Runnable, Boolean>(){

            @Override
            public void run(Plot plot, Runnable runnable, Boolean confirm) {
                if (confirm.booleanValue()) {
                    if (ExpireManager.this.plotsToDelete == null) {
                        ExpireManager.this.plotsToDelete = new HashSet();
                    }
                    ExpireManager.this.plotsToDelete.add(plot);
                    runnable.run();
                } else {
                    ExpireManager.this.deleteWithMessage(plot, runnable);
                }
            }
        });
    }

    public Collection<ExpiryTask> isExpired(ArrayDeque<ExpiryTask> applicable, Plot plot) {
        ExpiryTask expiryTask;
        ExpiryTask et;
        int i;
        for (int i2 = 0; i2 < applicable.size(); ++i2) {
            ExpiryTask et2 = applicable.poll();
            if (!et2.applies(plot.getArea())) continue;
            applicable.add(et2);
        }
        if (applicable.isEmpty()) {
            return new ArrayList<ExpiryTask>();
        }
        if (((Boolean)plot.getFlag(ServerPlotFlag.class)).booleanValue()) {
            return new ArrayList<ExpiryTask>();
        }
        boolean shouldCheckAccountAge = false;
        for (i = 0; i < applicable.size(); ++i) {
            et = applicable.poll();
            if (!et.applies(this.getAge(plot, et.shouldDeleteForUnknownOwner()))) continue;
            applicable.add(et);
            shouldCheckAccountAge |= et.getSettings().SKIP_ACCOUNT_AGE_DAYS != -1;
        }
        if (applicable.isEmpty()) {
            return new ArrayList<ExpiryTask>();
        }
        if (shouldCheckAccountAge) {
            for (i = 0; i < applicable.size(); ++i) {
                long accountAge;
                et = applicable.poll();
                if (!et.appliesAccountAge(accountAge = this.getAge(plot, et.shouldDeleteForUnknownOwner()))) continue;
                applicable.add(et);
            }
            if (applicable.isEmpty()) {
                return new ArrayList<ExpiryTask>();
            }
        }
        for (i = 0; i < applicable.size(); ++i) {
            expiryTask = applicable.poll();
            if (!(expiryTask.needsAnalysis() && plot.getArea().getType() == PlotAreaType.NORMAL || expiryTask.requiresConfirmation())) {
                return Collections.singletonList(expiryTask);
            }
            applicable.add(expiryTask);
        }
        for (i = 0; i < applicable.size(); ++i) {
            expiryTask = applicable.poll();
            if (!expiryTask.needsAnalysis() || plot.getArea().getType() != PlotAreaType.NORMAL) {
                return Collections.singletonList(expiryTask);
            }
            applicable.add(expiryTask);
        }
        return applicable;
    }

    public ArrayDeque<ExpiryTask> getTasks(PlotArea area) {
        ArrayDeque<ExpiryTask> queue = new ArrayDeque<ExpiryTask>(this.tasks);
        queue.removeIf(expiryTask -> !expiryTask.applies(area));
        return queue;
    }

    public void passesComplexity(PlotAnalysis analysis, Collection<ExpiryTask> applicable, RunnableVal<Boolean> success, Runnable failure) {
        if (analysis != null) {
            for (ExpiryTask et : applicable) {
                if (et.requiresConfirmation() || !et.applies(analysis)) continue;
                success.run(false);
                return;
            }
            for (ExpiryTask et : applicable) {
                if (!et.applies(analysis)) continue;
                success.run(true);
                return;
            }
            failure.run();
        }
    }

    public boolean runTask(final RunnableVal3<Plot, Runnable, Boolean> expiredTask) {
        if (this.running != 0) {
            return false;
        }
        this.running = 2;
        TaskManager.runTaskAsync(new Runnable(){
            private ConcurrentLinkedDeque<Plot> plots = null;

            @Override
            public void run() {
                final 2 task = this;
                if (ExpireManager.this.running != 2) {
                    ExpireManager.this.running = 0;
                    return;
                }
                if (this.plots == null) {
                    this.plots = new ConcurrentLinkedDeque<Plot>(PlotQuery.newQuery().allPlots().asList());
                }
                while (!this.plots.isEmpty()) {
                    if (ExpireManager.this.running != 2) {
                        ExpireManager.this.running = 0;
                        return;
                    }
                    ArrayDeque<ExpiryTask> applicable = new ArrayDeque<ExpiryTask>(ExpireManager.this.tasks);
                    final Plot plot = this.plots.poll();
                    PlotArea area = plot.getArea();
                    final Plot newPlot = area.getPlot(plot.getId());
                    final Collection<ExpiryTask> expired = ExpireManager.this.isExpired(applicable, newPlot);
                    if (expired.isEmpty()) continue;
                    for (ExpiryTask expiryTask : expired) {
                        if (expiryTask.needsAnalysis()) continue;
                        expiredTask.run(newPlot, () -> TaskManager.getPlatformImplementation().taskLaterAsync(task, TaskTime.ticks(1L)), expiryTask.requiresConfirmation());
                        return;
                    }
                    RunnableVal<PlotAnalysis> handleAnalysis = new RunnableVal<PlotAnalysis>(){

                        @Override
                        public void run(PlotAnalysis changed) {
                            ExpireManager.this.passesComplexity(changed, expired, new RunnableVal<Boolean>(){

                                @Override
                                public void run(Boolean confirmation) {
                                    expiredTask.run(newPlot, () -> TaskManager.getPlatformImplementation().taskLaterAsync(task, TaskTime.ticks(1L)), confirmation);
                                }
                            }, () -> {
                                Object plotFlag = GlobalFlagContainer.getInstance().getFlag(AnalysisFlag.class).createFlagInstance(changed.asList());
                                PlotFlagAddEvent event = ExpireManager.this.eventDispatcher.callFlagAdd((PlotFlag<?, ?>)plotFlag, plot);
                                if (event.getEventResult() == Result.DENY) {
                                    return;
                                }
                                newPlot.setFlag(event.getFlag());
                                TaskManager.runTaskLaterAsync(task, TaskTime.seconds(1L));
                            });
                        }
                    };
                    final Runnable doAnalysis = () -> PlotSquared.platform().hybridUtils().analyzePlot(newPlot, handleAnalysis);
                    PlotAnalysis analysis = newPlot.getComplexity(null);
                    if (analysis != null) {
                        ExpireManager.this.passesComplexity(analysis, expired, new RunnableVal<Boolean>(){

                            @Override
                            public void run(Boolean value) {
                                doAnalysis.run();
                            }
                        }, () -> TaskManager.getPlatformImplementation().taskLaterAsync(task, TaskTime.ticks(1L)));
                    } else {
                        doAnalysis.run();
                    }
                    return;
                }
                if (this.plots.isEmpty()) {
                    ExpireManager.this.running = 3;
                    TaskManager.runTaskLater(() -> {
                        if (ExpireManager.this.running == 3) {
                            ExpireManager.this.running = 2;
                            ExpireManager.this.runTask(expiredTask);
                        }
                    }, TaskTime.ticks(86400000L));
                } else {
                    TaskManager.runTaskLaterAsync(task, TaskTime.seconds(10L));
                }
            }
        });
        return true;
    }

    public void storeDate(UUID uuid, long time) {
        Long account_age;
        long diff;
        Long existing = this.dates_cache.put(uuid, time);
        if (existing != null && (diff = time - existing) > 0L && (account_age = this.account_age_cache.get(uuid)) != null) {
            this.account_age_cache.put(uuid, account_age + diff);
        }
    }

    public HashSet<Plot> getPendingExpired() {
        return this.plotsToDelete == null ? new HashSet<Plot>() : this.plotsToDelete;
    }

    public void deleteWithMessage(Plot plot, Runnable whenDone) {
        PlotPlayer<?> player;
        PlotUnlinkEvent event;
        if (plot.isMerged() && (event = this.eventDispatcher.callUnlink(plot.getArea(), plot, true, false, PlotUnlinkEvent.REASON.EXPIRE_DELETE)).getEventResult() != Result.DENY && plot.getPlotModificationManager().unlinkPlot(event.isCreateRoad(), event.isCreateSign())) {
            this.eventDispatcher.callPostUnlink(plot, PlotUnlinkEvent.REASON.EXPIRE_DELETE);
        }
        for (UUID helper : plot.getTrusted()) {
            player = PlotSquared.platform().playerManager().getPlayerIfExists(helper);
            if (player == null) continue;
            player.sendMessage(TranslatableCaption.of("trusted.plot_removed_user"), Templates.of("plot", plot.toString()));
        }
        for (UUID helper : plot.getMembers()) {
            player = PlotSquared.platform().playerManager().getPlayerIfExists(helper);
            if (player == null) continue;
            player.sendMessage(TranslatableCaption.of("trusted.plot_removed_user"), Templates.of("plot", plot.toString()));
        }
        plot.getPlotModificationManager().deletePlot(null, whenDone);
    }

    @Deprecated(forRemoval=true, since="6.4.0")
    public long getAge(UUID uuid) {
        return this.getAge(uuid, false);
    }

    public long getAge(UUID uuid, boolean shouldDeleteUnknownOwner) {
        if (PlotSquared.platform().playerManager().getPlayerIfExists(uuid) != null) {
            return 0L;
        }
        Long last = this.dates_cache.get(uuid);
        if (last == null) {
            OfflinePlotPlayer opp = PlotSquared.platform().playerManager().getOfflinePlayer(uuid);
            if (opp != null && (last = Long.valueOf(opp.getLastPlayed())) != 0L) {
                this.dates_cache.put(uuid, last);
            } else {
                return shouldDeleteUnknownOwner ? Long.MAX_VALUE : 0L;
            }
        }
        if (last == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - last;
    }

    public long getAge(Plot plot, boolean shouldDeleteUnknownOwner) {
        if (!plot.hasOwner() || Objects.equals(DBFunc.EVERYONE, plot.getOwner()) || PlotSquared.platform().playerManager().getPlayerIfExists(plot.getOwner()) != null || plot.getRunning() > 0) {
            return 0L;
        }
        Object value = plot.getFlag(KeepFlag.class);
        if (!value.equals(false)) {
            if (value instanceof Boolean) {
                if (Boolean.TRUE.equals(value)) {
                    return 0L;
                }
            } else if (value instanceof Long) {
                if ((Long)value > System.currentTimeMillis()) {
                    return 0L;
                }
            } else {
                return 0L;
            }
        }
        long min = Long.MAX_VALUE;
        for (UUID owner : plot.getOwners()) {
            long age = this.getAge(owner, shouldDeleteUnknownOwner);
            if (age >= min) continue;
            min = age;
        }
        return min;
    }
}

