/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.markdown;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import net.kyori.adventure.text.minimessage.markdown.MarkdownFlavor;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;
import net.kyori.examination.string.StringExaminer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class MiniMarkdownParser {
    private MiniMarkdownParser() {
    }

    public static @NonNull String stripMarkdown(@NonNull String input, @NonNull MarkdownFlavor markdownFlavor) {
        return MiniMarkdownParser.handle(input, true, markdownFlavor);
    }

    public static @NonNull String parse(@NonNull String input, @NonNull MarkdownFlavor markdownFlavor) {
        return MiniMarkdownParser.handle(input, false, markdownFlavor);
    }

    private static @NonNull String handle(@NonNull String input, boolean strip, @NonNull MarkdownFlavor markdownFlavor) {
        StringBuilder sb = new StringBuilder();
        int bold = -1;
        Insert boldSkip = null;
        int italic = -1;
        Insert italicSkip = null;
        int underline = -1;
        Insert underlineSkip = null;
        int strikeThrough = -1;
        Insert strikeThroughSkip = null;
        int obfuscate = -1;
        Insert obfuscateSkip = null;
        ArrayList<Insert> inserts = new ArrayList<Insert>();
        int skip = 0;
        int i = 0;
        while (i + skip < input.length()) {
            int currIndex = i + skip;
            char c = input.charAt(currIndex);
            char n = MiniMarkdownParser.next(currIndex, input);
            boolean shouldSkip = false;
            if (markdownFlavor.isBold(c, n)) {
                if (bold == -1) {
                    bold = sb.length();
                    boldSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(bold, "<bold>"));
                    inserts.add(new Insert(sb.length(), "</bold>"));
                    bold = -1;
                }
                skip += c == n ? 1 : 0;
                shouldSkip = true;
            } else if (markdownFlavor.isItalic(c, n)) {
                if (italic == -1) {
                    italic = sb.length();
                    italicSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(italic, "<italic>"));
                    inserts.add(new Insert(sb.length(), "</italic>"));
                    italic = -1;
                }
                skip += c == n ? 1 : 0;
                shouldSkip = true;
            } else if (markdownFlavor.isUnderline(c, n)) {
                if (underline == -1) {
                    underline = sb.length();
                    underlineSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(underline, "<underlined>"));
                    inserts.add(new Insert(sb.length(), "</underlined>"));
                    underline = -1;
                }
                skip += c == n ? 1 : 0;
                shouldSkip = true;
            } else if (markdownFlavor.isStrikeThrough(c, n)) {
                if (strikeThrough == -1) {
                    strikeThrough = sb.length();
                    strikeThroughSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(strikeThrough, "<strikethrough>"));
                    inserts.add(new Insert(sb.length(), "</strikethrough>"));
                    strikeThrough = -1;
                }
                skip += c == n ? 1 : 0;
                shouldSkip = true;
            } else if (markdownFlavor.isObfuscate(c, n)) {
                if (obfuscate == -1) {
                    obfuscate = sb.length();
                    obfuscateSkip = new Insert(sb.length(), c + "");
                } else {
                    inserts.add(new Insert(obfuscate, "<obfuscated>"));
                    inserts.add(new Insert(sb.length(), "</obfuscated>"));
                    obfuscate = -1;
                }
                skip += c == n ? 1 : 0;
                shouldSkip = true;
            }
            if (!shouldSkip) {
                sb.append(c);
            }
            ++i;
        }
        if (strip) {
            inserts.clear();
        } else {
            inserts.sort(Comparator.comparing(rec$ -> ((Insert)rec$).pos()).thenComparing(rec$ -> ((Insert)rec$).value()).reversed());
        }
        if (underline != -1) {
            inserts.add(underlineSkip);
        }
        if (bold != -1) {
            inserts.add(boldSkip);
        }
        if (italic != -1) {
            inserts.add(italicSkip);
        }
        if (strikeThrough != -1) {
            inserts.add(strikeThroughSkip);
        }
        if (obfuscate != -1) {
            inserts.add(obfuscateSkip);
        }
        for (Insert el : inserts) {
            sb.insert(el.pos(), el.value());
        }
        return sb.toString();
    }

    private static char next(int index, @NonNull String input) {
        if (index < input.length() - 1) {
            return input.charAt(index + 1);
        }
        return ' ';
    }

    static final class Insert
    implements Examinable {
        private final int pos;
        private final String value;

        Insert(int pos, @NonNull String value) {
            this.pos = pos;
            this.value = value;
        }

        private int pos() {
            return this.pos;
        }

        private @NonNull String value() {
            return this.value;
        }

        @Override
        public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("pos", this.pos), ExaminableProperty.of("value", this.value));
        }

        public String toString() {
            return this.examine(StringExaminer.simpleEscaping());
        }
    }
}

