/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.parser.ParsingException;
import net.kyori.adventure.text.minimessage.parser.Token;
import net.kyori.adventure.text.minimessage.parser.TokenType;
import net.kyori.adventure.text.minimessage.transformation.Inserting;
import net.kyori.adventure.text.minimessage.transformation.OneTimeTransformation;
import net.kyori.adventure.text.minimessage.transformation.Transformation;
import net.kyori.adventure.text.minimessage.transformation.TransformationParser;
import net.kyori.examination.ExaminableProperty;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TranslatableTransformation
extends OneTimeTransformation
implements Inserting {
    private static final Pattern DUM_SPLIT_PATTERN = Pattern.compile("['\"]:['\"]");
    private String key;
    private final List<Component> inners = new ArrayList<Component>();

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("lang") || name.equalsIgnoreCase("translate") || name.equalsIgnoreCase("tr");
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (args.isEmpty() || args.get(0).type() != TokenType.STRING) {
            throw new ParsingException("Doesn't know how to turn " + args + " into a translatable component", -1);
        }
        this.key = args.get(0).value();
        if (args.size() > 1) {
            String string = Token.asValueString(args.subList(2, args.size()));
            if (string.startsWith("'") || string.startsWith("\"")) {
                string = string.substring(1).substring(0, string.length() - 2);
            }
            for (String in : DUM_SPLIT_PATTERN.split(string)) {
                this.inners.add(MiniMessage.get().parse(in));
            }
        }
    }

    @Override
    public Component applyOneTime(@NonNull Component current,  @NonNull TextComponent.Builder parent, @NonNull Deque<Transformation> transformations) {
        if (!this.inners.isEmpty()) {
            parent.append(this.merge(Component.translatable(this.key, this.inners), current));
        } else {
            parent.append(this.merge(Component.translatable(this.key), current));
        }
        return current;
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("inners", this.inners));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TranslatableTransformation that = (TranslatableTransformation)other;
        return Objects.equals(this.key, that.key) && Objects.equals(this.inners, that.inners);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.inners);
    }

    public static class Parser
    implements TransformationParser<TranslatableTransformation> {
        @Override
        public TranslatableTransformation parse() {
            return new TranslatableTransformation();
        }
    }
}

