/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PacketTypeEnum
implements Iterable<PacketType> {
    protected Set<PacketType> members = new HashSet<PacketType>();

    public PacketTypeEnum() {
        this.registerAll();
    }

    protected void registerAll() {
        try {
            for (Field entry : this.getClass().getFields()) {
                boolean deprecated;
                if (!Modifier.isStatic(entry.getModifiers()) || !PacketType.class.isAssignableFrom(entry.getType())) continue;
                PacketType value = (PacketType)entry.get(null);
                if (value == null) {
                    throw new IllegalArgumentException("Field " + entry.getName() + " was null!");
                }
                value.setName(entry.getName());
                if (entry.getAnnotation(PacketType.ForceAsync.class) != null) {
                    value.forceAsync();
                }
                boolean bl = deprecated = entry.getAnnotation(Deprecated.class) != null;
                if (deprecated) {
                    value.setDeprecated();
                }
                if (this.members.contains(value)) {
                    if (deprecated) continue;
                    this.members.remove(value);
                    this.members.add(value);
                    continue;
                }
                this.members.add(value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean registerMember(PacketType instance, String name) {
        instance.setName(name);
        if (!this.members.contains(instance)) {
            this.members.add(instance);
            return true;
        }
        return false;
    }

    public boolean hasMember(PacketType member) {
        return this.members.contains(member);
    }

    public Set<PacketType> values() {
        return new HashSet<PacketType>(this.members);
    }

    @Override
    public Iterator<PacketType> iterator() {
        return this.members.iterator();
    }
}

