/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.injector.netty.channel.NettyChannelInjector;
import com.comphenix.protocol.utility.MinecraftReflection;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class NettyChannelProxy
implements Channel {
    private final Channel delegate;
    private final EventLoop eventLoop;
    private final NettyChannelInjector injector;

    public NettyChannelProxy(Channel delegate, EventLoop eventLoop, NettyChannelInjector injector) {
        this.delegate = delegate;
        this.eventLoop = eventLoop;
        this.injector = injector;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    public Channel parent() {
        return this.delegate.parent();
    }

    public ChannelConfig config() {
        return this.delegate.config();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public boolean isRegistered() {
        return this.delegate.isRegistered();
    }

    public boolean isActive() {
        return this.delegate.isActive();
    }

    public ChannelMetadata metadata() {
        return this.delegate.metadata();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public ChannelFuture closeFuture() {
        return this.delegate.closeFuture();
    }

    public boolean isWritable() {
        return this.delegate.isWritable();
    }

    public Channel.Unsafe unsafe() {
        return this.delegate.unsafe();
    }

    public ChannelPipeline pipeline() {
        return this.delegate.pipeline();
    }

    public ByteBufAllocator alloc() {
        return this.delegate.alloc();
    }

    public ChannelPromise newPromise() {
        return this.delegate.newPromise();
    }

    public ChannelProgressivePromise newProgressivePromise() {
        return this.delegate.newProgressivePromise();
    }

    public ChannelFuture newSucceededFuture() {
        return this.delegate.newSucceededFuture();
    }

    public ChannelFuture newFailedFuture(Throwable cause) {
        return this.delegate.newFailedFuture(cause);
    }

    public ChannelPromise voidPromise() {
        return this.delegate.voidPromise();
    }

    public ChannelFuture bind(SocketAddress localAddress) {
        return this.delegate.bind(localAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.delegate.connect(remoteAddress);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.delegate.connect(remoteAddress, localAddress);
    }

    public ChannelFuture disconnect() {
        return this.delegate.disconnect();
    }

    public ChannelFuture close() {
        return this.delegate.close();
    }

    public ChannelFuture deregister() {
        return this.delegate.deregister();
    }

    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.bind(localAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, promise);
    }

    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.delegate.connect(remoteAddress, localAddress, promise);
    }

    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.delegate.disconnect(promise);
    }

    public ChannelFuture close(ChannelPromise promise) {
        return this.delegate.close(promise);
    }

    public ChannelFuture deregister(ChannelPromise promise) {
        return this.delegate.deregister(promise);
    }

    public Channel read() {
        return this.delegate.read();
    }

    public ChannelFuture write(Object msg) {
        return this.write(msg, this.newPromise());
    }

    public ChannelFuture write(Object msg, ChannelPromise promise) {
        if (this.isPacketEventCallNeeded(msg)) {
            this.processPacketOutbound(msg, packet -> this.delegate.write(packet, promise));
            return promise;
        }
        return this.delegate.write(msg, promise);
    }

    public Channel flush() {
        return this.delegate.flush();
    }

    public ChannelFuture writeAndFlush(Object msg, ChannelPromise promise) {
        if (this.isPacketEventCallNeeded(msg)) {
            this.processPacketOutbound(msg, packet -> this.delegate.writeAndFlush(packet, promise));
            return promise;
        }
        return this.delegate.writeAndFlush(msg, promise);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.writeAndFlush(msg, this.newPromise());
    }

    public <T> Attribute<T> attr(AttributeKey<T> key) {
        return this.delegate.attr(key);
    }

    public int compareTo(@NotNull Channel o) {
        return this.delegate.compareTo((Object)o);
    }

    private boolean isPacketEventCallNeeded(Object msg) {
        if (MinecraftReflection.isPacketClass(msg)) {
            Boolean hasProcessedPacket = this.injector.processedPackets.get();
            if (hasProcessedPacket == Boolean.TRUE) {
                this.injector.processedPackets.set(Boolean.FALSE);
                return false;
            }
            return true;
        }
        return false;
    }

    private void processPacketOutbound(Object packet, Consumer<Object> delegateActionHandler) {
        Runnable action = this.injector.processOutbound(() -> delegateActionHandler.accept(packet));
        if (action != null) {
            action.run();
        }
    }
}

