/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.data;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.Vector;

public final class VectorialLocation {
    private final Reference<World> world;
    private final Vector vector;
    private final Vector direction;

    public VectorialLocation(World world, Vector vector, Vector direction) {
        this.world = new WeakReference<World>(world);
        this.vector = vector;
        this.direction = direction;
    }

    public VectorialLocation(VectorialLocation location) {
        this.world = location.world;
        this.vector = location.getVector().clone();
        this.direction = location.getDirection().clone();
    }

    public VectorialLocation(Location location) {
        this.world = new WeakReference<World>(location.getWorld());
        this.vector = location.toVector();
        this.direction = location.getDirection();
    }

    public World getWorld() {
        return this.world.get();
    }

    public Vector getVector() {
        return this.vector;
    }

    public Vector getDirection() {
        return this.direction;
    }
}

