/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.StructureModifier;
import com.vanillage.raytraceantixray.RayTraceAntiXray;
import com.vanillage.raytraceantixray.data.ChunkBlocks;
import com.vanillage.raytraceantixray.data.PlayerData;
import com.vanillage.raytraceantixray.data.VectorialLocation;
import com.vanillage.raytraceantixray.tasks.RayTraceCallable;
import java.util.HashMap;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class PacketListener
extends PacketAdapter {
    private final RayTraceAntiXray plugin;

    public PacketListener(RayTraceAntiXray plugin) {
        super((Plugin)plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Server.MAP_CHUNK, PacketType.Play.Server.UNLOAD_CHUNK, PacketType.Play.Server.RESPAWN});
        this.plugin = plugin;
    }

    public void onPacketSending(PacketEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.MAP_CHUNK) {
            PlayerData playerData = this.plugin.getPlayerData().get(event.getPlayer().getUniqueId());
            ChunkBlocks chunkBlocks = this.plugin.getPacketChunkBlocksCache().get(event.getPacket().getHandle());
            if (chunkBlocks == null) {
                Location location = event.getPlayer().getEyeLocation();
                if (!location.getWorld().equals(playerData.getLocations()[0].getWorld())) {
                    playerData = new PlayerData(this.plugin.getLocations((Entity)event.getPlayer(), new VectorialLocation(location)));
                    playerData.setCallable(new RayTraceCallable(playerData));
                    this.plugin.getPlayerData().put(event.getPlayer().getUniqueId(), playerData);
                }
                return;
            }
            Chunk chunk = chunkBlocks.getChunk();
            if (chunk == null) {
                return;
            }
            if (!chunk.D().getWorld().equals((Object)playerData.getLocations()[0].getWorld())) {
                Location location = event.getPlayer().getEyeLocation();
                if (!chunk.D().getWorld().equals((Object)location.getWorld())) {
                    return;
                }
                playerData = new PlayerData(this.plugin.getLocations((Entity)event.getPlayer(), new VectorialLocation(location)));
                playerData.setCallable(new RayTraceCallable(playerData));
                this.plugin.getPlayerData().put(event.getPlayer().getUniqueId(), playerData);
            }
            playerData.getChunks().put(chunkBlocks.getKey(), new ChunkBlocks(chunk, new HashMap<BlockPosition, Boolean>(chunkBlocks.getBlocks())));
        } else if (event.getPacketType() == PacketType.Play.Server.UNLOAD_CHUNK) {
            StructureModifier integers = event.getPacket().getIntegers();
            this.plugin.getPlayerData().get(event.getPlayer().getUniqueId()).getChunks().remove(ChunkCoordIntPair.c((int)((Integer)integers.read(0)), (int)((Integer)integers.read(1))));
        } else if (event.getPacketType() == PacketType.Play.Server.RESPAWN) {
            this.plugin.getPlayerData().get(event.getPlayer().getUniqueId()).getChunks().clear();
        }
    }
}

