/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.util;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;

public final class BlockOcclusionCulling {
    private static final IntArrayConsumer INCREASE_X = c2 -> {
        c2[0] = c2[0] + 1;
    };
    private static final IntArrayConsumer DECREASE_X = c2 -> {
        c2[0] = c2[0] - 1;
    };
    private static final IntArrayConsumer INCREASE_Y = c2 -> {
        c2[1] = c2[1] + 1;
    };
    private static final IntArrayConsumer DECREASE_Y = c2 -> {
        c2[1] = c2[1] - 1;
    };
    private static final IntArrayConsumer INCREASE_Z = c2 -> {
        c2[2] = c2[2] + 1;
    };
    private static final IntArrayConsumer DECREASE_Z = c2 -> {
        c2[2] = c2[2] - 1;
    };
    private static final IntArrayConsumer[] NEARBY_BLOCKS_X_PLANE_Y_POS_Z_POS = new IntArrayConsumer[]{INCREASE_Y, INCREASE_Z, DECREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_X_PLANE_Y_POS_Z_NEG = new IntArrayConsumer[]{INCREASE_Y, DECREASE_Z, DECREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_X_PLANE_Y_NEG_Z_POS = new IntArrayConsumer[]{DECREASE_Y, INCREASE_Z, INCREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_X_PLANE_Y_NEG_Z_NEG = new IntArrayConsumer[]{DECREASE_Y, DECREASE_Z, INCREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Y_PLANE_Z_POS_X_POS = new IntArrayConsumer[]{INCREASE_Z, INCREASE_X, DECREASE_Z};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Y_PLANE_Z_POS_X_NEG = new IntArrayConsumer[]{INCREASE_Z, DECREASE_X, DECREASE_Z};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Y_PLANE_Z_NEG_X_POS = new IntArrayConsumer[]{DECREASE_Z, INCREASE_X, INCREASE_Z};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Y_PLANE_Z_NEG_X_NEG = new IntArrayConsumer[]{DECREASE_Z, DECREASE_X, INCREASE_Z};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Z_PLANE_X_POS_Y_POS = new IntArrayConsumer[]{INCREASE_Y, INCREASE_X, DECREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Z_PLANE_X_POS_Y_NEG = new IntArrayConsumer[]{DECREASE_Y, INCREASE_X, INCREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Z_PLANE_X_NEG_Y_POS = new IntArrayConsumer[]{INCREASE_Y, DECREASE_X, DECREASE_Y};
    private static final IntArrayConsumer[] NEARBY_BLOCKS_Z_PLANE_X_NEG_Y_NEG = new IntArrayConsumer[]{DECREASE_Y, DECREASE_X, INCREASE_Y};
    private static final IBlockData AIR = Blocks.a.o();
    private final LongFunction<? extends Chunk> chunkGetter;
    private final Predicate<? super IBlockData> blockOcclusionPredicate;
    private final BlockIteratorFactory blockIteratorFactory;
    private final boolean unloadedChunkOccluding;
    private final boolean frustumCullingEnabled;

    public BlockOcclusionCulling(LongFunction<? extends Chunk> chunkGetter, Predicate<? super IBlockData> blockOcclusionPredicate, BlockIteratorFactory blockIteratorFactory, boolean unloadedChunkOccluding, boolean frustumCullingEnabled) {
        this.chunkGetter = chunkGetter;
        this.blockOcclusionPredicate = blockOcclusionPredicate;
        this.blockIteratorFactory = blockIteratorFactory;
        this.unloadedChunkOccluding = unloadedChunkOccluding;
        this.frustumCullingEnabled = frustumCullingEnabled;
    }

    public boolean isVisible(int x, int y, int z, double vectorX, double vectorY, double vectorZ, double directionX, double directionY, double directionZ) {
        double centerX = (double)x + 0.5;
        double centerY = (double)y + 0.5;
        double centerZ = (double)z + 0.5;
        double differenceX = vectorX - centerX;
        double differenceY = vectorY - centerY;
        double differenceZ = vectorZ - centerZ;
        double distanceSquared = differenceX * differenceX + differenceY * differenceY + differenceZ * differenceZ;
        int chunkX = x >> 4;
        int chunkZ = y >> 4;
        return this.isVisible(x, y, z, centerX, centerY, centerZ, differenceX, differenceY, differenceZ, distanceSquared, directionX, directionY, directionZ, this.chunkGetter.apply(ChunkCoordIntPair.c((int)chunkX, (int)chunkZ)), chunkX, chunkZ);
    }

    public boolean isVisible(int x, int y, int z, double centerX, double centerY, double centerZ, double differenceX, double differenceY, double differenceZ, double distanceSquared, double directionX, double directionY, double directionZ, Chunk chunk, int chunkX, int chunkZ) {
        if (this.frustumCullingEnabled && !((differenceX - directionX) * directionX + (differenceY - directionY) * directionY + (differenceZ - directionZ) * directionZ <= 0.0)) {
            return false;
        }
        int sectionY = y >> 4;
        ChunkSection section = null;
        if (chunk != null) {
            section = chunk.d()[sectionY - chunk.ak()];
            if (section != null && section.c()) {
                section = null;
            }
        } else if (this.unloadedChunkOccluding) {
            return false;
        }
        double distance = Math.sqrt(distanceSquared);
        Iterator<int[]> iterator = this.blockIteratorFactory.getBlockIterator(x, y, z, centerX, centerY, centerZ, differenceX / distance, differenceY / distance, differenceZ / distance, distance);
        while (iterator.hasNext()) {
            int[] ray = iterator.next();
            int rayX = ray[0];
            int rayY = ray[1];
            int rayZ = ray[2];
            int rayChunkX = rayX >> 4;
            int raySectionY = rayY >> 4;
            int rayChunkZ = rayZ >> 4;
            if (rayChunkX != chunkX || rayChunkZ != chunkZ) {
                chunkX = rayChunkX;
                sectionY = raySectionY;
                chunkZ = rayChunkZ;
                chunk = this.chunkGetter.apply(ChunkCoordIntPair.c((int)chunkX, (int)chunkZ));
                if (chunk == null) {
                    if (!this.unloadedChunkOccluding) continue;
                    return false;
                }
                if (sectionY < chunk.ak() || sectionY > chunk.al() - 1 || (section = chunk.d()[sectionY - chunk.ak()]) == null) continue;
                if (section.c()) {
                    section = null;
                    continue;
                }
            } else if (raySectionY != sectionY) {
                sectionY = raySectionY;
                if (sectionY < chunk.ak() || sectionY > chunk.al() - 1 || (section = chunk.d()[sectionY - chunk.ak()]) == null) continue;
                if (section.c()) {
                    section = null;
                    continue;
                }
            } else if (section == null) continue;
            if (!this.blockOcclusionPredicate.test((IBlockData)BlockOcclusionCulling.getBlockState(section, rayX, rayY, rayZ)) || !this.checkNearbyBlocks(x, y, z, ray, rayX, rayY, rayZ, differenceX, differenceY, differenceZ, chunk, section, chunkX, sectionY, chunkZ)) continue;
            return false;
        }
        return true;
    }

    private static IBlockData getBlockState(ChunkSection section, int x, int y, int z) {
        try {
            return section.a(x & 0xF, y & 0xF, z & 0xF);
        }
        catch (MissingPaletteEntryException e) {
            return AIR;
        }
    }

    private boolean checkNearbyBlocks(int x, int y, int z, int[] ray, int rayX, int rayY, int rayZ, double differenceX, double differenceY, double differenceZ, Chunk expectedChunk, ChunkSection expectedSection, int expectedChunkX, int expectedSectionY, int expectedChunkZ) {
        IntArrayConsumer decrease;
        IntArrayConsumer increase;
        IntArrayConsumer[] nearbyBlocks;
        double factor;
        double absDifferenceX = Math.abs(differenceX);
        double absDifferenceY = Math.abs(differenceY);
        double absDifferenceZ = Math.abs(differenceZ);
        double rayDifferenceX = rayX - x;
        double rayDifferenceY = rayY - y;
        double rayDifferenceZ = rayZ - z;
        if (absDifferenceX > absDifferenceY) {
            if (absDifferenceZ > absDifferenceX) {
                factor = BlockOcclusionCulling.divide(differenceZ, rayDifferenceZ);
                rayDifferenceX = BlockOcclusionCulling.multiply(factor, rayDifferenceX) - differenceX;
                rayDifferenceY = BlockOcclusionCulling.multiply(factor, rayDifferenceY) - differenceY;
                nearbyBlocks = rayDifferenceX > 0.0 ? (rayDifferenceY > 0.0 ? NEARBY_BLOCKS_Z_PLANE_X_NEG_Y_NEG : NEARBY_BLOCKS_Z_PLANE_X_NEG_Y_POS) : (rayDifferenceY > 0.0 ? NEARBY_BLOCKS_Z_PLANE_X_POS_Y_NEG : NEARBY_BLOCKS_Z_PLANE_X_POS_Y_POS);
                if (differenceZ > 0.0) {
                    increase = DECREASE_Z;
                    decrease = INCREASE_Z;
                } else {
                    increase = INCREASE_Z;
                    decrease = DECREASE_Z;
                }
            } else {
                factor = BlockOcclusionCulling.divide(differenceX, rayDifferenceX);
                rayDifferenceY = BlockOcclusionCulling.multiply(factor, rayDifferenceY) - differenceY;
                rayDifferenceZ = BlockOcclusionCulling.multiply(factor, rayDifferenceZ) - differenceZ;
                nearbyBlocks = rayDifferenceY > 0.0 ? (rayDifferenceZ > 0.0 ? NEARBY_BLOCKS_X_PLANE_Y_NEG_Z_NEG : NEARBY_BLOCKS_X_PLANE_Y_NEG_Z_POS) : (rayDifferenceZ > 0.0 ? NEARBY_BLOCKS_X_PLANE_Y_POS_Z_NEG : NEARBY_BLOCKS_X_PLANE_Y_POS_Z_POS);
                if (differenceX > 0.0) {
                    increase = DECREASE_X;
                    decrease = INCREASE_X;
                } else {
                    increase = INCREASE_X;
                    decrease = DECREASE_X;
                }
            }
        } else if (absDifferenceY > absDifferenceZ) {
            factor = BlockOcclusionCulling.divide(differenceY, rayDifferenceY);
            rayDifferenceZ = BlockOcclusionCulling.multiply(factor, rayDifferenceZ) - differenceZ;
            rayDifferenceX = BlockOcclusionCulling.multiply(factor, rayDifferenceX) - differenceX;
            nearbyBlocks = rayDifferenceZ > 0.0 ? (rayDifferenceX > 0.0 ? NEARBY_BLOCKS_Y_PLANE_Z_NEG_X_NEG : NEARBY_BLOCKS_Y_PLANE_Z_NEG_X_POS) : (rayDifferenceX > 0.0 ? NEARBY_BLOCKS_Y_PLANE_Z_POS_X_NEG : NEARBY_BLOCKS_Y_PLANE_Z_POS_X_POS);
            if (differenceY > 0.0) {
                increase = DECREASE_Y;
                decrease = INCREASE_Y;
            } else {
                increase = INCREASE_Y;
                decrease = DECREASE_Y;
            }
        } else {
            factor = BlockOcclusionCulling.divide(differenceZ, rayDifferenceZ);
            rayDifferenceX = BlockOcclusionCulling.multiply(factor, rayDifferenceX) - differenceX;
            rayDifferenceY = BlockOcclusionCulling.multiply(factor, rayDifferenceY) - differenceY;
            nearbyBlocks = rayDifferenceX > 0.0 ? (rayDifferenceY > 0.0 ? NEARBY_BLOCKS_Z_PLANE_X_NEG_Y_NEG : NEARBY_BLOCKS_Z_PLANE_X_NEG_Y_POS) : (rayDifferenceY > 0.0 ? NEARBY_BLOCKS_Z_PLANE_X_POS_Y_NEG : NEARBY_BLOCKS_Z_PLANE_X_POS_Y_POS);
            if (differenceZ > 0.0) {
                increase = DECREASE_Z;
                decrease = INCREASE_Z;
            } else {
                increase = INCREASE_Z;
                decrease = DECREASE_Z;
            }
        }
        for (int step = 0; step < nearbyBlocks.length; ++step) {
            nearbyBlocks[step].accept(ray);
            IBlockData blockState = this.getBlockState(ray[0], ray[1], ray[2], expectedChunk, expectedSection, expectedChunkX, expectedSectionY, expectedChunkZ);
            if (blockState == null) {
                if (this.unloadedChunkOccluding) {
                    return true;
                }
                blockState = AIR;
            }
            if (this.blockOcclusionPredicate.test((IBlockData)blockState)) continue;
            increase.accept(ray);
            if (ray[0] == x && ray[1] == y && ray[2] == z) {
                return false;
            }
            blockState = this.getBlockState(ray[0], ray[1], ray[2], expectedChunk, expectedSection, expectedChunkX, expectedSectionY, expectedChunkZ);
            if (blockState == null) {
                if (this.unloadedChunkOccluding) {
                    return true;
                }
                blockState = AIR;
            }
            if (!this.blockOcclusionPredicate.test((IBlockData)blockState)) {
                return false;
            }
            decrease.accept(ray);
        }
        return true;
    }

    private static double divide(double dividend, double divisor) {
        return (divisor == 0.0 && !Double.isNaN(dividend) ? Math.copySign(1.0, dividend) : dividend) / divisor;
    }

    private static double multiply(double factor1, double factor2) {
        return (factor2 == 0.0 ? Math.signum(factor1) : factor1) * factor2;
    }

    private IBlockData getBlockState(int x, int y, int z, Chunk expectedChunk, ChunkSection expectedSection, int expectedChunkX, int expectedSectionY, int expectedChunkZ) {
        int chunkX = x >> 4;
        int sectionY = y >> 4;
        int chunkZ = z >> 4;
        if (chunkX != expectedChunkX || chunkZ != expectedChunkZ) {
            expectedChunk = this.chunkGetter.apply(ChunkCoordIntPair.c((int)chunkX, (int)chunkZ));
            if (expectedChunk == null) {
                return null;
            }
            if (sectionY < expectedChunk.ak() || sectionY >= expectedChunk.al()) {
                return AIR;
            }
            expectedSection = expectedChunk.d()[sectionY - expectedChunk.ak()];
            if (expectedSection == null || expectedSection.c()) {
                return AIR;
            }
        } else if (sectionY != expectedSectionY) {
            if (sectionY < expectedChunk.ak() || sectionY >= expectedChunk.al()) {
                return AIR;
            }
            expectedSection = expectedChunk.d()[sectionY - expectedChunk.ak()];
            if (expectedSection == null || expectedSection.c()) {
                return AIR;
            }
        }
        return BlockOcclusionCulling.getBlockState(expectedSection, x, y, z);
    }

    @FunctionalInterface
    public static interface BlockIteratorFactory {
        public Iterator<int[]> getBlockIterator(int var1, int var2, int var3, double var4, double var6, double var8, double var10, double var12, double var14, double var16);
    }

    @FunctionalInterface
    private static interface IntArrayConsumer
    extends Consumer<int[]> {
    }
}

